/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CrossCountingTest {
    static final String LS = System.getProperty("line.separator");

    @Test
    public void crossCountingChecks() {
        this.crossCountingCheck(4, 100);
        this.crossCountingCheck(4, 10000);
        this.crossCountingCheck(12, 7);
        this.crossCountingCheck(12, 384);
        this.crossCountingCheck(12, 10000);
    }

    void crossCountingCheck(int lgK, int n) {
        HllSketch sk4 = CrossCountingTest.buildSketch(n, lgK, TgtHllType.HLL_4);
        int s4csum = CrossCountingTest.computeChecksum(sk4);
        HllSketch sk6 = CrossCountingTest.buildSketch(n, lgK, TgtHllType.HLL_6);
        int csum = CrossCountingTest.computeChecksum(sk6);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk8 = CrossCountingTest.buildSketch(n, lgK, TgtHllType.HLL_8);
        csum = CrossCountingTest.computeChecksum(sk8);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk6to4 = sk6.copyAs(TgtHllType.HLL_4);
        csum = CrossCountingTest.computeChecksum(sk6to4);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk8to4 = sk8.copyAs(TgtHllType.HLL_4);
        csum = CrossCountingTest.computeChecksum(sk8to4);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk4to6 = sk4.copyAs(TgtHllType.HLL_6);
        csum = CrossCountingTest.computeChecksum(sk4to6);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk8to6 = sk8.copyAs(TgtHllType.HLL_6);
        csum = CrossCountingTest.computeChecksum(sk8to6);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk4to8 = sk4.copyAs(TgtHllType.HLL_8);
        csum = CrossCountingTest.computeChecksum(sk4to8);
        Assert.assertEquals((int)csum, (int)s4csum);
        HllSketch sk6to8 = sk6.copyAs(TgtHllType.HLL_8);
        csum = CrossCountingTest.computeChecksum(sk6to8);
        Assert.assertEquals((int)csum, (int)s4csum);
    }

    private static HllSketch buildSketch(int n, int lgK, TgtHllType tgtHllType) {
        HllSketch sketch = new HllSketch(lgK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            sketch.update((long)i);
        }
        return sketch;
    }

    private static int computeChecksum(HllSketch sketch) {
        PairIterator itr = sketch.iterator();
        int checksum = 0;
        int key = 0;
        while (itr.nextAll()) {
            checksum += itr.getPair();
            key = itr.getKey();
        }
        return checksum;
    }

    @Test
    public void printlnTest() {
        CrossCountingTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        CrossCountingTest.print(s + LS);
    }

    static void print(String s) {
    }
}

