/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemorySegmentCompactCompressedHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;

final class DirectCompactCompressedSketch
extends DirectCompactSketch {
    private static final int START_PACKED_DATA_EXACT_MODE = 8;
    private static final int START_PACKED_DATA_ESTIMATION_MODE = 16;

    DirectCompactCompressedSketch(MemorySegment seg) {
        super(seg);
    }

    static DirectCompactCompressedSketch wrapInstance(MemorySegment srcSeg, short seedHash) {
        Util.checkSeedHashes((short)PreambleUtil.extractSeedHash(srcSeg), seedHash);
        return new DirectCompactCompressedSketch(srcSeg);
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstSeg) {
        if (dstSeg != null) {
            MemorySegment.copy(this.seg_, 0L, dstSeg, 0L, this.getCurrentBytes());
            return new DirectCompactSketch(dstSeg);
        }
        return CompactThetaSketch.heapify(this.seg_, 9001L);
    }

    @Override
    public int getCurrentBytes() {
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        int entryBits = PreambleUtil.extractEntryBitsV4(this.seg_);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(this.seg_);
        return preLongs * 8 + numEntriesBytes + PreambleUtil.wholeBytesToHoldBits(this.getRetainedEntries() * entryBits);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(this.seg_);
        int offsetBytes = preLongs > 1 ? 16 : 8;
        int numEntries = 0;
        for (int i = 0; i < numEntriesBytes; ++i) {
            numEntries |= Byte.toUnsignedInt(this.seg_.get(ValueLayout.JAVA_BYTE, (long)offsetBytes++)) << (i << 3);
        }
        return numEntries;
    }

    @Override
    public long getThetaLong() {
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        return preLongs > 1 ? PreambleUtil.extractThetaLongV4(this.seg_) : Long.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public HashIterator iterator() {
        return new MemorySegmentCompactCompressedHashIterator(this.seg_, (ThetaSketch.getPreambleLongs(this.seg_) > 1 ? 16 : 8) + PreambleUtil.extractNumEntriesBytesV4(this.seg_), PreambleUtil.extractEntryBitsV4(this.seg_), this.getRetainedEntries());
    }

    @Override
    long[] getCache() {
        int numEntries = this.getRetainedEntries();
        long[] cache = new long[numEntries];
        int i = 0;
        HashIterator it = this.iterator();
        while (it.next()) {
            cache[i++] = it.get();
        }
        return cache;
    }
}

