/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.GetEstimate;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetEstimateTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        GetEstimate func = new GetEstimate();
        Double result = (Double)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        GetEstimate func = new GetEstimate();
        Double result = (Double)func.exec(TUPLE_FACTORY.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        GetEstimate func = new GetEstimate();
        CpcSketch sketch = new CpcSketch();
        sketch.update(1L);
        sketch.update(2L);
        Double result = (Double)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0, (double)0.01);
    }

    @Test
    public void normalCaseCustomSeed() throws Exception {
        GetEstimate func = new GetEstimate("123");
        CpcSketch sketch = new CpcSketch(12, 123L);
        sketch.update(1L);
        sketch.update(2L);
        Double result = (Double)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0, (double)0.01);
    }
}

