/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.util.Random;
import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchToMeans;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToMeansTest {
    @Test
    public void nullInput() throws Exception {
        ArrayOfDoublesSketchToMeans func = new ArrayOfDoublesSketchToMeans();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        ArrayOfDoublesSketchToMeans func = new ArrayOfDoublesSketchToMeans();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInputSketch() throws Exception {
        ArrayOfDoublesSketchToMeans func = new ArrayOfDoublesSketchToMeans();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void oneEntryInputSketch() throws Exception {
        ArrayOfDoublesSketchToMeans func = new ArrayOfDoublesSketchToMeans();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)1.0);
    }

    @Test
    public void manyEntriesTwoValuesInputSketch() throws Exception {
        ArrayOfDoublesSketchToMeans func = new ArrayOfDoublesSketchToMeans();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        Random rand = new Random(0L);
        int numKeys = 10000;
        for (int i = 0; i < numKeys; ++i) {
            sketch.update((long)i, new double[]{rand.nextGaussian(), rand.nextGaussian() + 1.0});
        }
        Assert.assertTrue((sketch.getRetainedEntries() >= 4096 ? 1 : 0) != 0);
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.0, (double)0.04);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)1.0, (double)0.04);
    }
}

