/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.quantiles.DataToDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToDoublesSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final BagFactory bagFactory = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple());
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void execWrongValueType() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)"a"));
        func.exec(tupleFactory.newTuple((Object)bag));
    }

    @Test
    public void execNormalCase() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)1.0));
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void execMixedNullCase() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)1.0));
        bag.add(null);
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void accumulator() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        Tuple resultTuple = (Tuple)func.getValue();
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple());
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)1.0));
        func.accumulate(tupleFactory.newTuple((Object)bag));
        func.accumulate(tupleFactory.newTuple((Object)bag));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)1.0));
        bag.add(null);
        func.accumulate(tupleFactory.newTuple((Object)bag));
        func.accumulate(tupleFactory.newTuple((Object)bag));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        DataToDoublesSketch.Initial func = new DataToDoublesSketch.Initial();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple());
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertTrue((boolean)(resultTuple.get(0) instanceof DataBag));
        Assert.assertEquals((long)((DataBag)resultTuple.get(0)).size(), (long)1L);
    }

    @Test
    public void algebraicIntermediateFinalNullInputTuple() throws Exception {
        DataToDoublesSketch.IntermediateFinal func = new DataToDoublesSketch.IntermediateFinal();
        Tuple resultTuple = (Tuple)func.exec(null);
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalEmptyInputTuple() throws Exception {
        DataToDoublesSketch.IntermediateFinal func = new DataToDoublesSketch.IntermediateFinal();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple());
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalNormalCase() throws Exception {
        DataToDoublesSketch.IntermediateFinal func = new DataToDoublesSketch.IntermediateFinal();
        DataBag bag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)1.0));
        bag.add(tupleFactory.newTuple((Object)innerBag));
        UpdateDoublesSketch qs = DoublesSketch.builder().build();
        qs.update(2.0);
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(qs.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test
    public void algebraicIntermediateFinalMixedNullCase() throws Exception {
        DataToDoublesSketch.IntermediateFinal func = new DataToDoublesSketch.IntermediateFinal();
        DataBag bag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)1.0));
        innerBag.add(null);
        bag.add(tupleFactory.newTuple((Object)innerBag));
        UpdateDoublesSketch qs = DoublesSketch.builder().build();
        qs.update(2.0);
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(qs.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        DoublesSketch sketch = DataToDoublesSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        DataToDoublesSketch.IntermediateFinal func = new DataToDoublesSketch.IntermediateFinal();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)1.0));
        func.exec(tupleFactory.newTuple((Object)bag));
    }

    @Test
    public void schema() throws Exception {
        DataToDoublesSketch func = new DataToDoublesSketch();
        Schema schema = func.outputSchema(new Schema());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).type, (byte)110);
        Assert.assertEquals((int)schema.getField((int)0).schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).type, (byte)50);
    }

    private static DoublesSketch getSketch(Tuple tuple) throws Exception {
        Assert.assertNotNull((Object)tuple);
        Assert.assertEquals((int)tuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)tuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        return DoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes.get()));
    }
}

