/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_POSIX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FS_POSIX_Java6
extends FS_POSIX {
    private static final Method canExecute = FS_POSIX_Java6.needMethod(File.class, "canExecute", new Class[0]);
    private static final Method setExecute = FS_POSIX_Java6.needMethod(File.class, "setExecutable", Boolean.TYPE);

    static boolean hasExecute() {
        return canExecute != null && setExecute != null;
    }

    private static Method needMethod(Class<?> on, String name, Class<?> ... args) {
        try {
            return on.getMethod(name, args);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    FS_POSIX_Java6() {
    }

    FS_POSIX_Java6(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX_Java6(this);
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        try {
            Object r = canExecute.invoke((Object)f, (Object[])null);
            return (Boolean)r;
        }
        catch (IllegalArgumentException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
    }

    @Override
    public boolean setExecute(File f, boolean canExec) {
        try {
            Object r = setExecute.invoke((Object)f, canExec);
            return (Boolean)r;
        }
        catch (IllegalArgumentException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }
}

