package org.apache.torque.templates;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.option.MapOptionsConfiguration;
import org.apache.torque.generator.configuration.paths.CustomProjectPaths;
import org.apache.torque.generator.configuration.paths.DefaultTorqueGeneratorPaths;
import org.apache.torque.generator.configuration.paths.Maven2DirectoryProjectPaths;
import org.apache.torque.generator.configuration.paths.Maven2ProjectPaths;
import org.apache.torque.generator.control.Controller;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.stream.FileSourceProvider;
import org.junit.Before;
import org.junit.Test;

public class TestProcessing
{
    private static final String SCHEMA_DIR = "src/test/schema";

    @Before
    public void setUp() throws Exception
    {
        String testRoot = "target";
        {
            File generatedDocDir = new File(testRoot, "generated-docs");
            FileUtils.deleteDirectory(generatedDocDir);
        }
        {
            File generatedSourcesDir = new File(testRoot, "generated-sources");
            FileUtils.deleteDirectory(generatedSourcesDir);
        }
        {
            File generatedSources2Dir
                = new File(testRoot, "generated-sources-2");
            FileUtils.deleteDirectory(generatedSources2Dir);
        }
        {
            File generatedSqlDir = new File(testRoot, "generated-sql");
            FileUtils.deleteDirectory(generatedSqlDir);
        }
        {
            File generatedXdocsDir = new File(testRoot, "generated-xdocs");
            FileUtils.deleteDirectory(generatedXdocsDir);
        }
    }

    @Test
    public void testProcessSchemaXml() throws Exception
    {
        Controller controller = new Controller();
        List<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
        Map<String, String> overrideOptions = new HashMap<String, String>();
        overrideOptions.put("torque.database", "mysql");
        overrideOptions.put("torque.om.package", "org.apache.torque.test");
        overrideOptions.put("torque.om.generateMapInit", "true");

        // om templates
        CustomProjectPaths projectPaths
                = new CustomProjectPaths(
                    new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/om"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-sources-2"));
        Fileset sourceFileset = new Fileset();
        Set<String> sourceIncludes = new HashSet<String>();
        sourceIncludes.add("schema.xml");
        sourceFileset.setIncludes(sourceIncludes);
        sourceFileset.setBasedir(projectPaths.getDefaultSourcePath());
        SourceProvider sourceProvider
                = new FileSourceProvider(
                        null,
                        sourceFileset,
                        null);
        UnitDescriptor unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideSourceProvider(sourceProvider);
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // sql ddl templates
        projectPaths
                = new CustomProjectPaths(
                    new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/sql"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                null,
                new File("target/generated-sql"));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-sql-2"));
        unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // sql createdb templates
        projectPaths
                = new CustomProjectPaths(
                    new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/sql/createdb"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                null,
                new File("target/generated-sql"));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-sql-2"));
        unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // idbroker-init-sql templates
        projectPaths
                = new CustomProjectPaths(
                    new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/idtable"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                null,
                new File("target/generated-sql"));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-sql-2"));
        unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // html doc templates
        projectPaths = new CustomProjectPaths(
                    new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/doc/html"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                null,
                new File("target/generated-docs"));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-docs-2"));
        unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // xdoc doc templates
        projectPaths = new CustomProjectPaths(
                new Maven2DirectoryProjectPaths(new File(".")));
        projectPaths.setConfigurationDir(
                new File("src/main/resources/org/apache/torque/templates/doc/xdoc"));
        projectPaths.setSourceDir(
                new File(SCHEMA_DIR));
        projectPaths.setOutputDirectory(
                null,
                new File("target/generated-xdocs"));
        projectPaths.setOutputDirectory(
                Maven2ProjectPaths.MODIFIABLE_OUTPUT_DIR_KEY,
                new File("target/generated-xdocs-2"));
        unitDescriptor = new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideOptions(
                new MapOptionsConfiguration(overrideOptions));
        unitDescriptors.add(unitDescriptor);

        // generate
        controller.run(unitDescriptors);
    }
}
