/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.plugin;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.felix.framework.Felix;
import org.apache.felix.ipojo.junit4osgi.plugin.Installer;
import org.apache.felix.ipojo.junit4osgi.plugin.ReportPrintStream;
import org.apache.felix.ipojo.junit4osgi.plugin.StringOutputStream;
import org.apache.felix.ipojo.junit4osgi.plugin.XMLReport;
import org.apache.felix.ipojo.junit4osgi.plugin.log.LogServiceImpl;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class Junit4osgiPlugin
extends AbstractMojo {
    private MavenProject m_project;
    private List m_pluginArtifacts;
    private File m_reportsDirectory;
    private File m_targetDir;
    private boolean m_deployProjectArtifact;
    private List bundles;
    private Map configuration;
    private boolean m_logEnable;
    private int m_total;
    private int m_totalFailures;
    private int m_totalErrors;
    private List m_errors = new ArrayList();
    private List m_failures = new ArrayList();
    private List m_results = new ArrayList();
    private LogServiceImpl m_logService;
    private boolean skip;
    private boolean testFailureIgnore;
    private boolean hideOutputs;
    private Map felixConf;
    static /* synthetic */ Class class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Tests are skipped");
            return;
        }
        List bundles = this.parseBundleList();
        bundles.addAll(this.getTestBundle());
        ArrayList<Object> activators = new ArrayList<Object>();
        this.m_logService = new LogServiceImpl();
        if (this.m_logEnable) {
            activators.add(this.m_logService);
        } else {
            this.getLog().info((CharSequence)"Log Service disabled");
        }
        activators.add(new Installer(this.m_pluginArtifacts, bundles, this.m_project, this.m_deployProjectArtifact));
        this.felixConf = new HashMap();
        this.felixConf.put("felix.systembundle.activators", activators);
        this.felixConf.put("org.osgi.framework.storage.clean", "onFirstInit");
        this.felixConf.put("ipojo.log.level", "WARNING");
        this.felixConf.put("org.osgi.framework.bootdelegation", "junit.framework, org.osgi.service.log, net.sourceforge.cobertura.coveragedata");
        this.felixConf.put("org.osgi.framework.storage", this.m_targetDir.getAbsolutePath() + "/felix-cache");
        if (this.configuration != null) {
            this.felixConf.putAll(this.configuration);
            String bd = (String)this.felixConf.get("org.osgi.framework.bootdelegation");
            if (bd.indexOf("junit.framework") == -1) {
                bd.concat(", junit.framework");
            }
            if (bd.indexOf("org.osgi.service.log") == -1) {
                bd.concat(", org.osgi.service.log");
            }
            if (bd.indexOf("net.sourceforge.cobertura.coveragedata") == -1) {
                bd.concat(", net.sourceforge.cobertura.coveragedata");
            }
        }
        System.out.println("");
        System.out.println("-------------------------------------------------------");
        System.out.println(" T E S T S");
        System.out.println("-------------------------------------------------------");
        Felix felix = new Felix(this.felixConf);
        try {
            felix.start();
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        this.waitForStability(felix.getBundleContext());
        Object runner = this.waitForRunnerService(felix.getBundleContext());
        this.invokeRun(runner, felix.getBundleContext());
        try {
            felix.stop();
            felix.waitForStop(5000L);
            File cache = new File(this.m_targetDir.getAbsolutePath() + "/felix-cache");
            cache.delete();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        if (this.m_totalErrors > 0 || this.m_totalFailures > 0) {
            if (!this.testFailureIgnore) {
                throw new MojoFailureException("There are test failures. \n\nPlease refer to " + this.m_reportsDirectory.getAbsolutePath() + " for the individual test results.");
            }
            this.getLog().warn((CharSequence)("There are test failures. \n\nPlease refer to " + this.m_reportsDirectory.getAbsolutePath() + " for the individual test results."));
        }
    }

    private void waitForStability(BundleContext context) throws MojoFailureException {
        int count;
        boolean bundleStability = this.getBundleStability(context);
        for (count = 0; !bundleStability && count < 500; ++count) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            bundleStability = this.getBundleStability(context);
        }
        if (count == 500) {
            this.getLog().error((CharSequence)"Bundle stability isn't reached after 500 tries");
            this.dumpBundles(context);
            throw new MojoFailureException("Cannot reach the bundle stability");
        }
        boolean serviceStability = false;
        int count1 = 0;
        int count2 = 0;
        for (count = 0; !serviceStability && count < 500; ++count) {
            try {
                ServiceReference[] refs = context.getServiceReferences(null, null);
                count1 = refs.length;
                Thread.sleep(500L);
                refs = context.getServiceReferences(null, null);
                count2 = refs.length;
                serviceStability = count1 == count2;
                continue;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                serviceStability = false;
            }
        }
        if (count == 500) {
            this.getLog().error((CharSequence)("Service stability isn't reached after 500 tries (" + count1 + " != " + count2));
            this.dumpBundles(context);
            throw new MojoFailureException("Cannot reach the service stability");
        }
    }

    private boolean getBundleStability(BundleContext bc) {
        boolean stability = true;
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            stability = stability && bundles[i].getState() == 32;
        }
        return stability;
    }

    private List parseBundleList() {
        ArrayList<URL> toDeploy = new ArrayList<URL>();
        if (this.bundles == null) {
            return toDeploy;
        }
        System.out.println("Deploy URL bundles " + this.bundles);
        for (int i = 0; i < this.bundles.size(); ++i) {
            String bundle = (String)this.bundles.get(i);
            try {
                URL url = new URL(bundle);
                toDeploy.add(url);
                continue;
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)(bundle + " is not a valid url, bundle ignored"));
            }
        }
        return toDeploy;
    }

    private List getTestBundle() {
        ArrayList<URL> toDeploy = new ArrayList<URL>();
        Set dependencies = this.m_project.getDependencyArtifacts();
        Iterator artifactIterator = dependencies.iterator();
        while (artifactIterator.hasNext()) {
            Artifact artifact = (Artifact)artifactIterator.next();
            if (artifact.getScope() == null) continue;
            File file = artifact.getFile();
            try {
                if (file.exists()) {
                    JarFile jar;
                    if (!file.getName().endsWith("jar") || (jar = new JarFile(file)).getManifest().getMainAttributes().getValue("Bundle-ManifestVersion") == null) continue;
                    toDeploy.add(file.toURL());
                    continue;
                }
                this.getLog().info((CharSequence)("The artifact " + artifact.getFile().getName() + " does not exist."));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)(file + " is not a valid bundle, this artifact is ignored"));
            }
        }
        return toDeploy;
    }

    private Object waitForRunnerService(BundleContext bc) {
        ServiceReference ref = bc.getServiceReference((class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner == null ? (class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner = Junit4osgiPlugin.class$("org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner")) : class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner).getName());
        int count = 0;
        while (ref == null && count < 1000) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ref = bc.getServiceReference((class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner == null ? Junit4osgiPlugin.class$("org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner") : class$org$apache$felix$ipojo$junit4osgi$OSGiJunitRunner).getName());
        }
        if (ref != null) {
            return bc.getService(ref);
        }
        this.getLog().error((CharSequence)"Junit Runner service unavailable");
        return null;
    }

    private void invokeRun(Object runner, BundleContext bc) {
        try {
            TestFailure tf;
            Enumeration e;
            TestResult tr;
            int i;
            Method getTest = runner.getClass().getMethod("getTests", new Class[0]);
            List tests = (List)getTest.invoke(runner, new Object[0]);
            Method run = this.getRunMethod(runner);
            for (i = 0; i < tests.size(); ++i) {
                this.executeTest(runner, (Test)tests.get(i), run, bc);
            }
            System.out.println("\nResults :");
            if (this.m_failures.size() > 0) {
                System.out.println("\nFailed tests:");
                for (i = 0; i < this.m_failures.size(); ++i) {
                    tr = (TestResult)this.m_failures.get(i);
                    e = tr.failures();
                    while (e.hasMoreElements()) {
                        tf = (TestFailure)e.nextElement();
                        System.out.println(" " + tf.toString());
                    }
                }
            }
            if (this.m_failures.size() > 0) {
                System.out.println("\nTests in error:");
                for (i = 0; i < this.m_errors.size(); ++i) {
                    tr = (TestResult)this.m_errors.get(i);
                    e = tr.errors();
                    while (e.hasMoreElements()) {
                        tf = (TestFailure)e.nextElement();
                        System.out.println(" " + tf.toString());
                    }
                }
            }
            System.out.println("\nTests run: " + this.m_total + ", Failures: " + this.m_totalFailures + ", Errors:" + this.m_totalErrors + "\n");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private Method getRunMethod(Object runner) {
        Method[] methods = runner.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("run") || methods[i].getParameterTypes().length != 1 || methods[i].getParameterTypes()[0].equals(Long.TYPE)) continue;
            return methods[i];
        }
        this.getLog().error((CharSequence)"Cannot find the run method");
        return null;
    }

    private String getTestName(Object test) {
        try {
            Method getName = test.getClass().getMethod("getName", new Class[0]);
            String name = (String)getName.invoke(test, new Object[0]);
            if (name == null) {
                name = test.toString();
            }
            return name;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    private void executeTest(Object runner, Test test, Method run, BundleContext bc) {
        try {
            XMLReport report = new XMLReport();
            String name = this.getTestName(test);
            System.out.println("Running " + name);
            TestResult tr = new TestResult();
            tr.addListener((TestListener)new ResultListener(report));
            test.run(tr);
            this.m_results.add(tr);
            if (tr.wasSuccessful()) {
                System.out.println("Tests run: " + tr.runCount() + ", Failures: " + tr.failureCount() + ", Errors: " + tr.errorCount() + ", Time elapsed: " + report.elapsedTimeAsString(report.m_endTime - report.m_endTime) + " sec");
            } else {
                System.out.println("Tests run: " + tr.runCount() + ", Failures: " + tr.failureCount() + ", Errors: " + tr.errorCount() + ", Time elapsed: " + report.elapsedTimeAsString(report.m_endTime - report.m_endTime) + " sec <<< FAILURE!");
                if (tr.errorCount() > 0) {
                    this.m_errors.add(tr);
                }
                if (tr.failureCount() > 0) {
                    this.m_failures.add(tr);
                }
            }
            this.m_total += tr.runCount();
            this.m_totalFailures += tr.failureCount();
            this.m_totalErrors += tr.errorCount();
            report.generateReport(test, tr, this.m_reportsDirectory, bc, this.felixConf);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    public void dumpBundles(BundleContext bc) {
        this.getLog().info((CharSequence)"Bundles:");
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            this.getLog().info((CharSequence)(bundles[i].getSymbolicName() + " - " + bundles[i].getState()));
        }
    }

    public LogServiceImpl getLogService() {
        return this.m_logService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResultListener
    implements TestListener {
        private XMLReport m_report;
        private boolean m_abort;
        private PrintStream m_outBackup = System.out;
        private PrintStream m_errBackup = System.err;
        private StringOutputStream m_out = new StringOutputStream();
        private StringOutputStream m_err = new StringOutputStream();

        public ResultListener(XMLReport report) {
            this.m_report = report;
        }

        public void addError(Test test, Throwable throwable) {
            this.m_report.testError(test, throwable, this.m_out.toString(), this.m_err.toString(), Junit4osgiPlugin.this.getLogService().getLoggedMessages());
            this.m_abort = true;
        }

        public void addFailure(Test test, AssertionFailedError assertionfailederror) {
            this.m_report.testFailed(test, (Throwable)assertionfailederror, this.m_out.toString(), this.m_err.toString(), Junit4osgiPlugin.this.getLogService().getLoggedMessages());
            this.m_abort = true;
        }

        public void endTest(Test test) {
            if (!this.m_abort) {
                this.m_report.testSucceeded(test);
            }
            System.setErr(this.m_errBackup);
            System.setOut(this.m_outBackup);
            Junit4osgiPlugin.this.getLogService().reset();
        }

        public void startTest(Test test) {
            this.m_abort = false;
            this.m_report.testStarting();
            System.setErr(new ReportPrintStream((OutputStream)this.m_err, this.m_errBackup, Junit4osgiPlugin.this.hideOutputs));
            System.setOut(new ReportPrintStream((OutputStream)this.m_out, this.m_outBackup, Junit4osgiPlugin.this.hideOutputs));
            Junit4osgiPlugin.this.getLogService().enableOutputStream();
        }
    }
}

