/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins.finaliser.shade;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.api.plugin.FinalPlugin;
import org.apache.felix.atomos.utils.core.plugins.finaliser.shade.ShadeConfig;
import org.apache.felix.atomos.utils.core.plugins.finaliser.shade.ShadePreHolder;

public class ShaderPlugin
implements FinalPlugin<ShadeConfig> {
    private ShadeConfig config;
    List<ShadePreHolder> candidates = new ArrayList<ShadePreHolder>();
    Map<JarFile, Path> map = new HashMap<JarFile, Path>();

    ShadePreHolder compute(String name) {
        return this.candidates.stream().filter(c -> name.equals(c.getName())).findAny().orElseGet(() -> {
            ShadePreHolder s = new ShadePreHolder(name);
            this.candidates.add(s);
            return s;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinal(Context context) {
        Path shadesJar = this.config.shadeOutputDirectory().resolve("shaded.jar");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(new Attributes.Name("Created-By"), "atomos-maven-plugin");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "foooBar");
        try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(shadesJar.toFile()), manifest);){
            List<Path> classpath = context.getFiles(new FileType[]{FileType.ARTIFACT, FileType.INDEX_JAR}).collect(Collectors.toList());
            classpath.forEach(p -> {
                try {
                    JarFile jar = new JarFile(p.toFile());
                    this.map.put(jar, (Path)p);
                    jar.stream().filter(Predicate.not(ZipEntry::isDirectory)).forEach(je -> this.compute(je.getName()).add(jar));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.candidates.forEach(c -> {
                try {
                    if ("module-info.class".equals(c.getName())) {
                        return;
                    }
                    if ("META-INF/MANIFEST.MF".equals(c.getName())) {
                        return;
                    }
                    JarEntry jarEntry = new JarEntry(c.getName());
                    jarOutputStream.putNextEntry(jarEntry);
                    if (c.getName().startsWith("services")) {
                        AtomicBoolean ab = new AtomicBoolean();
                        StringBuilder sb = new StringBuilder();
                        for (JarFile jar : c.all()) {
                            if (ab.getAndSet(true)) {
                                sb.append("\n");
                            }
                            JarEntry e = jar.getJarEntry(c.getName());
                            InputStream is = jar.getInputStream(e);
                            sb.append(is);
                        }
                        jarOutputStream.write(sb.toString().getBytes());
                    } else {
                        if (!c.allSameChecksum()) {
                            System.out.println(c.getName());
                            c.getSource().forEach((k, v) -> {
                                System.out.println("- Checksum: " + k);
                                System.out.println("-- List of Jars:");
                                v.stream().map(this.map::get).map(Path::toAbsolutePath).map(p -> "-- " + p.toString()).forEach(System.out::println);
                            });
                        }
                        JarFile j = c.any();
                        JarEntry e = j.getJarEntry(c.getName());
                        InputStream is = j.getInputStream(e);
                        jarOutputStream.write(is.readAllBytes());
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.map.forEach((j, p) -> {
                try {
                    j.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public void init(ShadeConfig config) {
        this.config = config;
    }
}

