/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.samples.bridge;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProvisionActivator
implements BundleActivator {
    private final ServletContext servletContext;

    public ProvisionActivator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void start(BundleContext context) throws Exception {
        this.servletContext.setAttribute(BundleContext.class.getName(), (Object)context);
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles()) {
            this.servletContext.log("Installing bundle [" + url + "]");
            Bundle bundle = context.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        for (Bundle bundle : installed) {
            bundle.start();
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private List<URL> findBundles() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : this.servletContext.getResourcePaths("/WEB-INF/bundles/")) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = this.servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        return list;
    }
}

