/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.internal.LoginModuleCreator;
import org.apache.felix.jaas.internal.LoginModuleProvider;

final class ConfigLoginModuleProvider
implements LoginModuleProvider {
    private final Map options;
    private final AppConfigurationEntry.LoginModuleControlFlag controlFlag;
    private final int ranking;
    private final String realmName;
    private final String className;
    private final LoginModuleCreator moduleCreator;

    ConfigLoginModuleProvider(String realmName, String className, Map options, AppConfigurationEntry.LoginModuleControlFlag controlFlag, int order, LoginModuleCreator moduleCreator) {
        this.options = Collections.unmodifiableMap(options);
        this.controlFlag = controlFlag;
        this.ranking = order;
        this.realmName = realmName;
        this.className = className;
        this.moduleCreator = moduleCreator;
    }

    @Override
    public Map<String, ?> options() {
        return this.options;
    }

    @Override
    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    @Override
    public int ranking() {
        return this.ranking;
    }

    @Override
    public String realmName() {
        return this.realmName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public LoginModule createLoginModule() {
        return this.moduleCreator.newInstance(this.className);
    }

    public String toString() {
        return "ConfigLoginModuleProvider{flag=" + this.controlFlag + ", ranking=" + this.ranking + ", realmName='" + this.realmName + '\'' + ", className='" + this.className + '\'' + '}';
    }
}

