/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.rootcause;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.rootcause.DSComp;
import org.apache.felix.rootcause.DSRef;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

public class DSRootCause {
    private static final int MAX_RECURSION = 10;
    private final ServiceComponentRuntime scr;

    public DSRootCause(ServiceComponentRuntime scr) {
        this.scr = scr;
    }

    public Optional<DSComp> getRootCause(String iface) {
        return this.getRootCause(iface, null);
    }

    public Optional<DSComp> getRootCause(String iface, Collection<ComponentDescriptionDTO> allDTOs) {
        Collection cache = allDTOs == null ? this.scr.getComponentDescriptionDTOs(new Bundle[0]) : allDTOs;
        return cache.stream().filter(desc -> this.offersInterface((ComponentDescriptionDTO)desc, iface)).map(d -> this.getRootCause((ComponentDescriptionDTO)d, (Collection<ComponentDescriptionDTO>)cache)).findFirst();
    }

    public DSComp getRootCause(ComponentDescriptionDTO desc) {
        return this.getRootCause(desc, null);
    }

    public DSComp getRootCause(ComponentDescriptionDTO desc, Collection<ComponentDescriptionDTO> allDTOs) {
        HashSet<String> visitedNames = new HashSet<String>();
        return this.getRootCause(desc, visitedNames, 0, allDTOs == null ? new ArrayList() : allDTOs);
    }

    private DSComp getRootCause(ComponentDescriptionDTO desc, Set<String> visitedNames, int level, Collection<ComponentDescriptionDTO> cache) {
        if (level > 10 || visitedNames.contains(desc.name)) {
            return null;
        }
        boolean added = visitedNames.add(desc.name);
        DSComp dsComp = new DSComp();
        dsComp.desc = desc;
        Collection instances = this.scr.getComponentConfigurationDTOs(desc);
        if (instances.isEmpty()) {
            return dsComp;
        }
        for (ComponentConfigurationDTO instance : instances) {
            for (UnsatisfiedReferenceDTO ref : instance.unsatisfiedReferences) {
                ReferenceDTO refdef = this.getReference(desc, ref.name);
                DSRef unresolvedRef = this.createRef(ref, refdef);
                unresolvedRef.candidates = this.getCandidates(ref, refdef, visitedNames, level + 1, cache);
                dsComp.unsatisfied.add(unresolvedRef);
            }
        }
        if (added) {
            visitedNames.remove(desc.name);
        }
        return dsComp;
    }

    private DSRef createRef(UnsatisfiedReferenceDTO unsatifiedRef, ReferenceDTO refdef) {
        DSRef ref = new DSRef();
        ref.name = unsatifiedRef.name;
        ref.filter = unsatifiedRef.target;
        ref.iface = refdef.interfaceName;
        return ref;
    }

    private List<DSComp> getCandidates(UnsatisfiedReferenceDTO ref, ReferenceDTO refdef, Set<String> visitedNames, int level, Collection<ComponentDescriptionDTO> cache) {
        if (cache.isEmpty()) {
            cache.addAll(this.scr.getComponentDescriptionDTOs(new Bundle[0]));
        }
        ArrayList<DSComp> result = new ArrayList<DSComp>();
        List candidates = cache.stream().filter(desc -> this.offersInterface((ComponentDescriptionDTO)desc, refdef.interfaceName)).collect(Collectors.toList());
        for (ComponentDescriptionDTO c : candidates) {
            DSComp r = this.getRootCause(c, visitedNames, level, cache);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    private boolean offersInterface(ComponentDescriptionDTO desc, String interfaceName) {
        return Arrays.asList(desc.serviceInterfaces).contains(interfaceName);
    }

    private ReferenceDTO getReference(ComponentDescriptionDTO desc, String name) {
        return Arrays.asList(desc.references).stream().filter(ref -> ref.name.equals(name)).findFirst().get();
    }
}

