/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.ant;

import org.apache.felix.scrplugin.Log;
import org.apache.tools.ant.Task;

public class AntLog
implements Log {
    private final Task task;

    AntLog(Task task) {
        this.task = task;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void debug(String content) {
        this.task.log(content, 4);
    }

    @Override
    public void debug(String content, Throwable error) {
        this.task.log(content, error, 4);
    }

    @Override
    public void debug(Throwable error) {
        this.task.log(error, 4);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String content) {
        this.task.log(content, 2);
    }

    @Override
    public void info(String content, Throwable error) {
        this.task.log(content, error, 2);
    }

    @Override
    public void info(Throwable error) {
        this.task.log(error, 2);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String content) {
        this.task.log(content, 1);
    }

    @Override
    public void warn(String content, String location, int lineNumber) {
        this.warn(String.format("%s [%s,%d]", content, location, lineNumber));
    }

    @Override
    public void warn(String content, String location, int lineNumber, int columNumber) {
        this.warn(String.format("%s [%s,%d:%d]", content, location, lineNumber, columNumber));
    }

    @Override
    public void warn(String content, Throwable error) {
        this.task.log(content, error, 1);
    }

    @Override
    public void warn(Throwable error) {
        this.task.log(error, 1);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String content) {
        this.task.log(content, 0);
    }

    @Override
    public void error(String content, String location, int lineNumber) {
        this.error(String.format("%s [%s,%d]", content, location, lineNumber));
    }

    @Override
    public void error(String content, String location, int lineNumber, int columnNumber) {
        this.error(String.format("%s [%s,%d:%d]", content, location, lineNumber, columnNumber));
    }

    @Override
    public void error(String content, Throwable error) {
        this.task.log(content, error, 0);
    }

    @Override
    public void error(Throwable error) {
        this.task.log(error, 0);
    }
}

