/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReady;
import org.apache.felix.systemready.SystemReadyCheck;
import org.apache.felix.systemready.SystemReadyMonitor;
import org.apache.felix.systemready.SystemStatus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.felix.systemready.SystemReadyMonitor")
@Designate(ocd=Config.class)
public class SystemReadyMonitorImpl
implements SystemReadyMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(policy=ReferencePolicy.DYNAMIC)
    private volatile List<SystemReadyCheck> checks;
    private final BundleContext context;
    private final AtomicReference<ServiceRegistration<SystemReady>> sreg = new AtomicReference();
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();
    private final AtomicReference<Collection<CheckStatus>> curStates;
    private final Map<String, String> errorMsgs = new HashMap<String, String>();

    @Activate
    public SystemReadyMonitorImpl(BundleContext context, Config config) {
        CheckStatus checkStatus = new CheckStatus("dummy", StateType.READY, CheckStatus.State.YELLOW, "");
        this.curStates = new AtomicReference<Set<CheckStatus>>(Collections.singleton(checkStatus));
        this.context = context;
        this.executor.set(Executors.newSingleThreadScheduledExecutor());
        this.executor.get().scheduleAtFixedRate(this::check, 0L, config.poll_interval(), TimeUnit.MILLISECONDS);
        this.log.info("Activated. Running checks every {} ms.", (Object)config.poll_interval());
    }

    @Deactivate
    public void deactivate() {
        ScheduledExecutorService s = this.executor.getAndSet(null);
        s.shutdownNow();
        ServiceRegistration reg = this.sreg.getAndSet(null);
        if (reg != null) {
            reg.unregister();
        }
        this.log.info("Deactivated.");
    }

    @Override
    public SystemStatus getStatus(StateType stateType) {
        Collection filtered = stateType == StateType.READY ? this.curStates.get() : (Collection)this.curStates.get().stream().filter(status -> status.getType() == StateType.ALIVE).collect(Collectors.toList());
        return new SystemStatus(filtered);
    }

    private void check() {
        try {
            CheckStatus.State prevState = this.getStatus(StateType.READY).getState();
            ArrayList<SystemReadyCheck> currentChecks = new ArrayList<SystemReadyCheck>(this.checks);
            List checkNames = currentChecks.stream().map(check -> check.getName()).collect(Collectors.toList());
            this.log.debug("Running system checks {}", checkNames);
            List<CheckStatus> statuses = this.evaluateAllChecks(currentChecks);
            this.curStates.set(statuses);
            CheckStatus.State currState = this.getStatus(StateType.READY).getState();
            if (currState != prevState) {
                this.manageMarkerService(currState);
            }
            this.log.debug("Checks finished");
        }
        catch (Exception e) {
            this.log.warn("Exception when running checks", (Throwable)e);
            this.errorMsgs.clear();
        }
    }

    private List<CheckStatus> evaluateAllChecks(List<SystemReadyCheck> currentChecks) {
        return currentChecks.stream().map(s -> this.getStatus((SystemReadyCheck)s)).sorted(Comparator.comparing(CheckStatus::getCheckName)).collect(Collectors.toList());
    }

    private void manageMarkerService(CheckStatus.State currState) {
        if (this.executor.get() != null) {
            if (currState == CheckStatus.State.GREEN) {
                SystemReady readyService = new SystemReady(){};
                this.sreg.compareAndSet(null, (ServiceRegistration<SystemReady>)this.context.registerService(SystemReady.class, (Object)readyService, null));
            } else {
                ServiceRegistration reg = this.sreg.getAndSet(null);
                if (reg != null) {
                    reg.unregister();
                }
            }
        }
    }

    private final CheckStatus getStatus(SystemReadyCheck c) {
        try {
            CheckStatus status = c.getStatus();
            if (status.getState() != CheckStatus.State.GREEN) {
                String msg = status.toString();
                if (!msg.equals(this.errorMsgs.get(c.getName()))) {
                    this.errorMsgs.put(c.getName(), msg);
                    this.log.info("Executing systemready check {} returned {}", (Object)c.getName(), (Object)msg);
                }
            } else if (this.errorMsgs.remove(c.getName()) != null) {
                this.log.info("Executing systemready check {} back to GREEN", (Object)c.getName());
            }
            return status;
        }
        catch (Throwable e) {
            this.errorMsgs.remove(c.getName());
            this.log.error("Exception while executing systemready check {} : {}", new Object[]{c.getClass().getName(), e.getMessage(), e});
            return new CheckStatus(c.getName(), StateType.READY, CheckStatus.State.RED, e.getMessage());
        }
    }

    @ObjectClassDefinition(name="System Ready Monitor", description="System ready monitor for System Ready Checks")
    public static @interface Config {
        @AttributeDefinition(name="Poll interval", description="Number of milliseconds between subsequents updates of all the checks")
        public long poll_interval() default 5000L;
    }
}

