/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.obr.internal;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.plugins.obr.internal.AbstractBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.plugins.obr.internal.OsgiDeployer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

class OsgiBundleRepositoryRenderHelper
extends AbstractBundleRepositoryRenderHelper {
    OsgiBundleRepositoryRenderHelper(BundleContext bundleContext) {
        super(bundleContext, RepositoryAdmin.class.getName());
    }

    @Override
    String getData(String filter, boolean details, Bundle[] bundles) {
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        if (admin != null) {
            StringWriter sw = new StringWriter();
            JSONWriter json = new JSONWriter(sw);
            try {
                Resource[] resources;
                json.object();
                json.key("status");
                json.value(true);
                json.key("details");
                json.value(details);
                Repository[] repositories = admin.listRepositories();
                if (repositories != null) {
                    json.key("repositories");
                    json.array();
                    for (int i = 0; i < repositories.length; ++i) {
                        json.object();
                        json.key("lastModified");
                        json.value(repositories[i].getLastModified());
                        json.key("name");
                        json.value(repositories[i].getName());
                        json.key("url");
                        json.value(repositories[i].getURL());
                        json.endObject();
                    }
                    json.endArray();
                }
                if ((resources = admin.discoverResources(filter)) != null) {
                    json.key("resources");
                    json.array();
                    for (int i = 0; i < resources.length; ++i) {
                        this.toJSON(json, resources[i], bundles, details);
                    }
                    json.endArray();
                }
                json.endObject();
                json.flush();
            }
            catch (IOException e) {
                this.logger.error("Failed to serialize repository to JSON object.", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("Failed to parse filter '" + filter + "'", (Throwable)e);
                try {
                    String reason = "filter=" + filter;
                    if (e.getMessage() != null) {
                        reason = e.getMessage() + "(" + reason + ")";
                    }
                    json.key("error");
                    json.value(reason);
                    json.endObject();
                    json.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return sw.toString();
        }
        return "{}";
    }

    @Override
    void doAction(String action, String urlParam) throws IOException, ServletException {
        URL uri;
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        Repository[] repos = admin.listRepositories();
        Repository repo = this.getRepository(repos, urlParam);
        URL uRL = uri = repo != null ? repo.getURL() : new URL(urlParam);
        if ("delete".equals(action)) {
            if (!admin.removeRepository(uri)) {
                throw new ServletException("Failed to remove repository with URL " + uri);
            }
        } else if ("add".equals(action) || "refresh".equals(action)) {
            try {
                admin.addRepository(uri);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Failed to " + action + " repository " + uri + ": " + e.toString());
            }
        }
    }

    @Override
    final void doDeploy(String[] bundles, boolean start, boolean optional) {
        if (bundles == null || bundles.length == 0) {
            this.logger.info("No resources to deploy");
            return;
        }
        RepositoryAdmin repoAdmin = (RepositoryAdmin)this.getRepositoryAdmin();
        Resolver resolver = repoAdmin.resolver();
        for (int i = 0; i < bundles.length; ++i) {
            String filter;
            Resource[] resources;
            String bundle = bundles[i];
            if (bundle == null || bundle.equals("-") || (resources = repoAdmin.discoverResources(filter = "(id=" + bundle + ")")) == null || resources.length <= 0) continue;
            resolver.add(resources[0]);
        }
        OsgiDeployer.deploy(resolver, start);
    }

    private final Repository getRepository(Repository[] repos, String repositoryUrl) {
        if (repositoryUrl == null || repositoryUrl.length() == 0) {
            return null;
        }
        for (int i = 0; i < repos.length; ++i) {
            if (!repositoryUrl.equals(repos[i].getURL().toString())) continue;
            return repos[i];
        }
        return null;
    }

    private final void toJSON(JSONWriter json, Resource resource, Bundle[] bundles, boolean details) throws IOException {
        String symbolicName = resource.getSymbolicName();
        Version version = resource.getVersion();
        String installed = "";
        for (int i = 0; symbolicName != null && installed.length() == 0 && bundles != null && i < bundles.length; ++i) {
            Version ver = bundles[i].getVersion();
            if (!symbolicName.equals(bundles[i].getSymbolicName())) continue;
            installed = ver.toString();
        }
        json.object();
        json.key("id");
        json.value(resource.getId());
        json.key("presentationname");
        json.value(resource.getPresentationName());
        json.key("symbolicname");
        json.value(symbolicName);
        json.key("url");
        json.value(resource.getURL());
        json.key("version");
        json.value(version);
        json.key("categories");
        json.value(resource.getCategories());
        json.key("installed");
        json.value(installed);
        if (details) {
            Requirement[] unsatisfied;
            Resource[] optional;
            Capability[] caps = resource.getCapabilities();
            if (caps != null) {
                json.key("capabilities");
                json.array();
                for (int i = 0; i < caps.length; ++i) {
                    json.key("name");
                    json.value(caps[i].getName());
                    json.key("properties");
                    this.toJSON(json, caps[i].getProperties());
                }
                json.endArray();
            }
            Requirement[] reqs = resource.getRequirements();
            if (caps != null) {
                json.key("requirements");
                json.array();
                for (int i = 0; i < reqs.length; ++i) {
                    json.key("name");
                    json.value(reqs[i].getName());
                    json.key("filter");
                    json.value(reqs[i].getFilter());
                    json.key("optional");
                    json.value(reqs[i].isOptional());
                }
                json.endArray();
            }
            RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
            Resolver resolver = admin.resolver();
            resolver.add(resource);
            resolver.resolve();
            Resource[] required = resolver.getRequiredResources();
            if (required != null) {
                json.key("required");
                json.array();
                for (int i = 0; i < required.length; ++i) {
                    this.toJSON(json, required[i], bundles, false);
                }
                json.endArray();
            }
            if ((optional = resolver.getOptionalResources()) != null) {
                json.key("optional");
                json.array();
                for (int i = 0; optional != null && i < optional.length; ++i) {
                    this.toJSON(json, optional[i], bundles, false);
                }
                json.endArray();
            }
            if ((unsatisfied = resolver.getUnsatisfiedRequirements()) != null) {
                json.key("unsatisfied");
                json.array();
                for (int i = 0; i < unsatisfied.length; ++i) {
                    json.key("name");
                    json.value(unsatisfied[i].getName());
                    json.key("filter");
                    json.value(unsatisfied[i].getFilter());
                    json.key("optional");
                    json.value(unsatisfied[i].isOptional());
                }
                json.endArray();
            }
        }
        json.endObject();
    }

    private void toJSON(JSONWriter writer, Map props) throws IOException {
        writer.object();
        for (Map.Entry entry : props.entrySet()) {
            writer.key(entry.getKey().toString());
            writer.value(entry.getValue());
        }
        writer.endObject();
    }
}

