/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.amd;

import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.js.amd.JSAMDEmitter;

public class ExportWriter {
    private static final String CLASSES_TYPES = "__CLASSES$TYPES__";
    private static final String CLASSES_STRINGS = "__CLASSES$STRINGS__";
    private static final String RUNTIME_TYPES = "__RUNTIME$TYPES__";
    private static final String RUNTIME_STRINGS = "__RUNTIME$STRINGS__";
    private final JSAMDEmitter emitter;
    private List<Dependency> runtime = new ArrayList<Dependency>();
    private List<Dependency> types = new ArrayList<Dependency>();

    public ExportWriter(JSAMDEmitter emitter) {
        this.emitter = emitter;
    }

    public void queueExports(ITypeDefinition type, boolean outputString) {
        if (outputString) {
            this.emitter.write("[");
            this.emitter.write("\"exports\"");
        }
        this.emitter.write(", ");
        if (outputString) {
            this.emitter.write(RUNTIME_STRINGS);
        } else {
            this.emitter.write(RUNTIME_TYPES);
        }
        if (outputString) {
            this.emitter.write(CLASSES_STRINGS);
        } else {
            this.emitter.write(CLASSES_TYPES);
        }
        if (outputString) {
            this.emitter.write("]");
        }
    }

    public void writeExports(ITypeDefinition type, boolean outputString) {
        int end;
        int start;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = this.runtime.size();
        for (Dependency dependency : this.runtime) {
            sb.append(dependency.output(outputString, "runtime", outputString));
            if (i < len - 1) {
                sb.append(", ");
            }
            ++i;
        }
        if (outputString) {
            start = this.emitter.builder().indexOf(RUNTIME_STRINGS);
            end = start + RUNTIME_STRINGS.length();
            this.emitter.builder().replace(start, end, sb.toString());
        } else {
            start = this.emitter.builder().indexOf(RUNTIME_TYPES);
            end = start + RUNTIME_TYPES.length();
            this.emitter.builder().replace(start, end, sb.toString());
        }
        sb = new StringBuilder();
        i = 0;
        len = this.types.size();
        if (len > 0) {
            sb.append(", ");
        }
        for (Dependency dependency : this.types) {
            sb.append(dependency.output(outputString, "classes", outputString));
            if (i < len - 1) {
                sb.append(", ");
            }
            ++i;
        }
        if (outputString) {
            int start2 = this.emitter.builder().indexOf(CLASSES_STRINGS);
            int end2 = start2 + CLASSES_STRINGS.length();
            this.emitter.builder().replace(start2, end2, sb.toString());
        } else {
            int start3 = this.emitter.builder().indexOf(CLASSES_TYPES);
            int end3 = start3 + CLASSES_TYPES.length();
            this.emitter.builder().replace(start3, end3, sb.toString());
        }
    }

    void addImports(ITypeDefinition type) {
        ArrayList imports = new ArrayList();
        type.getContainedScope().getScopeNode().getAllImports(imports);
        for (String imp : imports) {
            String name = ExportWriter.toBaseName(imp);
            if (this.isExcludedImport(imp)) continue;
            this.addDependency(name, imp, false, false);
        }
    }

    void addFrameworkDependencies() {
        this.runtime.add(new Dependency("AS3", "AS3", false, false));
    }

    protected boolean isExcludedImport(String imp) {
        return imp.startsWith("__AS3__");
    }

    public void addDependency(String baseName, String qualifiedName, boolean isNative, boolean isPlugin) {
        this.types.add(new Dependency(baseName, qualifiedName, isNative, isPlugin));
    }

    static String toBaseName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        String basename = name.substring(name.lastIndexOf(".") + 1);
        return basename;
    }

    static class Dependency {
        private final String baseName;
        private final String qualifiedName;
        private final boolean isNative;
        private final boolean isPlugin;

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public Dependency(String baseName, String qualifiedName, boolean isNative, boolean isPlugin) {
            this.baseName = baseName;
            this.qualifiedName = qualifiedName;
            this.isNative = isNative;
            this.isPlugin = isPlugin;
        }

        public String toString() {
            return this.qualifiedName;
        }

        public String output(boolean outputString, String base, boolean qualified) {
            StringBuilder sb = new StringBuilder();
            if (outputString) {
                sb.append("\"" + base + "/" + this.qualifiedName.replaceAll("\\.", "/") + "\"");
            } else if (qualified) {
                sb.append(this.qualifiedName);
            } else {
                sb.append(this.baseName);
            }
            return sb.toString();
        }
    }
}

