/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.chat;

import io.github.ollama4j.models.chat.OllamaChatMessage;
import io.github.ollama4j.models.chat.OllamaChatMessageRole;
import io.github.ollama4j.models.chat.OllamaChatRequest;
import io.github.ollama4j.models.chat.OllamaChatToolCalls;
import io.github.ollama4j.utils.Options;
import io.github.ollama4j.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaChatRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaChatRequestBuilder.class);
    private OllamaChatRequest request;

    private OllamaChatRequestBuilder(String model, List<OllamaChatMessage> messages) {
        this.request = new OllamaChatRequest(model, false, messages);
    }

    public static OllamaChatRequestBuilder getInstance(String model) {
        return new OllamaChatRequestBuilder(model, new ArrayList<OllamaChatMessage>());
    }

    public OllamaChatRequest build() {
        return this.request;
    }

    public void reset() {
        this.request = new OllamaChatRequest(this.request.getModel(), this.request.isThink(), new ArrayList<OllamaChatMessage>());
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content) {
        return this.withMessage(role, content, Collections.emptyList());
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content, List<OllamaChatToolCalls> toolCalls) {
        List<OllamaChatMessage> messages = this.request.getMessages();
        messages.add(new OllamaChatMessage(role, content, null, toolCalls, null));
        return this;
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content, List<OllamaChatToolCalls> toolCalls, List<File> images) {
        List<OllamaChatMessage> messages = this.request.getMessages();
        List<byte[]> binaryImages = images.stream().map(file -> {
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                LOG.warn("File '{}' could not be accessed, will not add to message!", (Object)file.toPath(), (Object)e);
                return new byte[0];
            }
        }).collect(Collectors.toList());
        messages.add(new OllamaChatMessage(role, content, null, toolCalls, binaryImages));
        return this;
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content, List<OllamaChatToolCalls> toolCalls, String ... imageUrls) {
        List<OllamaChatMessage> messages = this.request.getMessages();
        ArrayList<byte[]> binaryImages = null;
        if (imageUrls.length > 0) {
            binaryImages = new ArrayList<byte[]>();
            for (String imageUrl : imageUrls) {
                try {
                    binaryImages.add(Utils.loadImageBytesFromUrl(imageUrl));
                }
                catch (URISyntaxException e) {
                    LOG.warn("URL '{}' could not be accessed, will not add to message!", (Object)imageUrl, (Object)e);
                }
                catch (IOException e) {
                    LOG.warn("Content of URL '{}' could not be read, will not add to message!", (Object)imageUrl, (Object)e);
                }
            }
        }
        messages.add(new OllamaChatMessage(role, content, null, toolCalls, binaryImages));
        return this;
    }

    public OllamaChatRequestBuilder withMessages(List<OllamaChatMessage> messages) {
        return new OllamaChatRequestBuilder(this.request.getModel(), messages);
    }

    public OllamaChatRequestBuilder withOptions(Options options) {
        this.request.setOptions(options.getOptionsMap());
        return this;
    }

    public OllamaChatRequestBuilder withGetJsonResponse() {
        this.request.setReturnFormatJson(true);
        return this;
    }

    public OllamaChatRequestBuilder withTemplate(String template) {
        this.request.setTemplate(template);
        return this;
    }

    public OllamaChatRequestBuilder withStreaming() {
        this.request.setStream(true);
        return this;
    }

    public OllamaChatRequestBuilder withKeepAlive(String keepAlive) {
        this.request.setKeepAlive(keepAlive);
        return this;
    }

    public OllamaChatRequestBuilder withThinking(boolean think) {
        this.request.setThink(think);
        return this;
    }
}

