/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.resourceprovider;

import java.util.function.BiFunction;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.agents.plan.resourceprovider.SerializableResourceProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class JavaSerializableResourceProvider
extends SerializableResourceProvider {
    @JsonIgnore
    private SerializableResource resource;
    private final String serializedResource;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JavaSerializableResourceProvider(String name, ResourceType type, String module, String clazz, String serializedResource) {
        super(name, type, module, clazz);
        this.serializedResource = serializedResource;
    }

    public JavaSerializableResourceProvider(String name, ResourceType type, String module, String clazz, SerializableResource resource, String serializedResource) {
        super(name, type, module, clazz);
        this.resource = resource;
        this.serializedResource = serializedResource;
    }

    public static JavaSerializableResourceProvider createResourceProvider(String name, ResourceType type, SerializableResource resource) throws JsonProcessingException {
        return new JavaSerializableResourceProvider(name, type, resource.getClass().getPackageName(), resource.getClass().getName(), resource, objectMapper.writeValueAsString(resource));
    }

    public String getSerializedResource() {
        return this.serializedResource;
    }

    @Override
    public Resource provide(BiFunction<String, ResourceType, Resource> getResource) throws Exception {
        if (this.resource == null) {
            this.resource = (SerializableResource)objectMapper.readValue(this.serializedResource, Class.forName(this.getClazz()));
        }
        return this.resource;
    }
}

