/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.tools.serializer;

import java.io.IOException;
import org.apache.flink.agents.api.tools.ToolMetadata;
import org.apache.flink.agents.plan.Function;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.tools.FunctionTool;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class FunctionToolJsonDeserializer
extends StdDeserializer<FunctionTool> {
    public FunctionToolJsonDeserializer() {
        super(FunctionTool.class);
    }

    @Override
    public FunctionTool deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Function func;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ToolMetadata metadata = new ObjectMapper().treeToValue((TreeNode)node.get("metadata"), ToolMetadata.class);
        JsonNode functionNode = node.get("function");
        String funcType = functionNode.get("func_type").asText();
        if (JavaFunction.class.getSimpleName().equals(funcType)) {
            func = this.deserializeJavaFunction(functionNode);
        } else if (PythonFunction.class.getSimpleName().equals(funcType)) {
            func = this.deserializePythonFunction(functionNode);
        } else {
            throw new IOException("Unsupported function type: " + funcType);
        }
        return new FunctionTool(metadata, func);
    }

    private PythonFunction deserializePythonFunction(JsonNode execNode) {
        String module = execNode.get("module").asText();
        String qualName = execNode.get("qualname").asText();
        return new PythonFunction(module, qualName);
    }

    private JavaFunction deserializeJavaFunction(JsonNode execNode) throws IOException {
        String qualName = execNode.get("qualname").asText();
        String methodName = execNode.get("method_name").asText();
        Class[] parameterTypes = new Class[execNode.get("parameter_types").size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                String parameterTypeName = execNode.get("parameter_types").get(i).asText();
                parameterTypes[i] = Class.forName(parameterTypeName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to deserialize parameter type", e);
            }
        }
        try {
            return new JavaFunction(qualName, methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create JavaFunction with qualName \"%s\" and method name \"%s\"", qualName, methodName), e);
        }
    }
}

