/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.python.event;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.flink.agents.api.Event;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class PythonEvent
extends Event {
    private final byte[] event;
    private final String eventType;
    private final String eventString;

    public PythonEvent(byte[] event, String eventType, String eventString) {
        this.event = event;
        this.eventType = eventType;
        this.eventString = eventString;
    }

    @JsonCreator
    public PythonEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="event") byte[] event, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="eventString") String eventString) {
        super(id, attributes);
        this.event = event;
        this.eventType = eventType;
        this.eventString = eventString;
    }

    @JsonIgnore
    public byte[] getEvent() {
        return this.event;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventString() {
        return this.eventString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PythonEvent other = (PythonEvent)o;
        return Arrays.equals(this.event, other.event) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.eventString, other.eventString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.event), this.eventType, this.eventString);
    }
}

