/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.utils;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.api.common.state.ListState;

public class StateUtil {
    public static boolean listStateNotEmpty(ListState<?> listState) throws Exception {
        return listState.get() != null && ((Iterable)listState.get()).iterator().hasNext();
    }

    public static <T> int removeFromListState(ListState<T> listState, T element) throws Exception {
        Iterator listStateIterator = ((Iterable)listState.get()).iterator();
        if (!listStateIterator.hasNext()) {
            return 0;
        }
        int removedElementCount = 0;
        ArrayList remaining = new ArrayList();
        while (listStateIterator.hasNext()) {
            Object next = listStateIterator.next();
            if (next.equals(element)) {
                ++removedElementCount;
                continue;
            }
            remaining.add(next);
        }
        listState.clear();
        listState.update(remaining);
        return removedElementCount;
    }

    public static <T> T pollFromListState(ListState<T> listState) throws Exception {
        Iterator listStateIterator = ((Iterable)listState.get()).iterator();
        if (!listStateIterator.hasNext()) {
            return null;
        }
        Object polled = listStateIterator.next();
        ArrayList remaining = new ArrayList();
        while (listStateIterator.hasNext()) {
            remaining.add(listStateIterator.next());
        }
        listState.clear();
        listState.update(remaining);
        return polled;
    }
}

