/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.session;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.rest.activeconnection.APIActiveConnection;
import org.apache.guacamole.rest.connection.APIConnection;
import org.apache.guacamole.rest.connectiongroup.APIConnectionGroup;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryResource;
import org.apache.guacamole.rest.directory.DirectoryResourceFactory;
import org.apache.guacamole.rest.history.HistoryResource;
import org.apache.guacamole.rest.schema.SchemaResource;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;
import org.apache.guacamole.rest.user.APIUser;
import org.apache.guacamole.rest.usergroup.APIUserGroup;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserContextResource {
    private final UserContext userContext;
    @Inject
    private DirectoryObjectResourceFactory<User, APIUser> userResourceFactory;
    @Inject
    private DirectoryResourceFactory<ActiveConnection, APIActiveConnection> activeConnectionDirectoryResourceFactory;
    @Inject
    private DirectoryResourceFactory<Connection, APIConnection> connectionDirectoryResourceFactory;
    @Inject
    private DirectoryResourceFactory<ConnectionGroup, APIConnectionGroup> connectionGroupDirectoryResourceFactory;
    @Inject
    private DirectoryResourceFactory<SharingProfile, APISharingProfile> sharingProfileDirectoryResourceFactory;
    @Inject
    private DirectoryResourceFactory<User, APIUser> userDirectoryResourceFactory;
    @Inject
    private DirectoryResourceFactory<UserGroup, APIUserGroup> userGroupDirectoryResourceFactory;

    @AssistedInject
    public UserContextResource(@Assisted UserContext userContext) {
        this.userContext = userContext;
    }

    @Path(value="self")
    public DirectoryObjectResource<User, APIUser> getSelfResource() throws GuacamoleException {
        return this.userResourceFactory.create(this.userContext, this.userContext.getUserDirectory(), (Identifiable)this.userContext.self());
    }

    @Path(value="activeConnections")
    public DirectoryResource<ActiveConnection, APIActiveConnection> getActiveConnectionDirectoryResource() throws GuacamoleException {
        return this.activeConnectionDirectoryResourceFactory.create(this.userContext, this.userContext.getActiveConnectionDirectory());
    }

    @Path(value="connections")
    public DirectoryResource<Connection, APIConnection> getConnectionDirectoryResource() throws GuacamoleException {
        return this.connectionDirectoryResourceFactory.create(this.userContext, this.userContext.getConnectionDirectory());
    }

    @Path(value="connectionGroups")
    public DirectoryResource<ConnectionGroup, APIConnectionGroup> getConnectionGroupDirectoryResource() throws GuacamoleException {
        return this.connectionGroupDirectoryResourceFactory.create(this.userContext, this.userContext.getConnectionGroupDirectory());
    }

    @Path(value="sharingProfiles")
    public DirectoryResource<SharingProfile, APISharingProfile> getSharingProfileDirectoryResource() throws GuacamoleException {
        return this.sharingProfileDirectoryResourceFactory.create(this.userContext, this.userContext.getSharingProfileDirectory());
    }

    @Path(value="users")
    public DirectoryResource<User, APIUser> getUserDirectoryResource() throws GuacamoleException {
        return this.userDirectoryResourceFactory.create(this.userContext, this.userContext.getUserDirectory());
    }

    @Path(value="userGroups")
    public DirectoryResource<UserGroup, APIUserGroup> getUserGroupDirectoryResource() throws GuacamoleException {
        return this.userGroupDirectoryResourceFactory.create(this.userContext, this.userContext.getUserGroupDirectory());
    }

    @Path(value="history")
    public HistoryResource getHistoryResource() {
        return new HistoryResource(this.userContext);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() {
        return new SchemaResource(this.userContext);
    }
}

