/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.handshake.HandshakeException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.HandshakeHandler;
import org.apache.ignite.internal.network.netty.MessageHandler;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.message.HandshakeFinishMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.OutNetworkObject;
import org.jetbrains.annotations.TestOnly;

public class RecoveryServerHandshakeManager
implements HandshakeManager {
    private final UUID launchId;
    private final String consistentId;
    private final NetworkMessagesFactory messageFactory;
    private final CompletableFuture<NettySender> handshakeCompleteFuture = new CompletableFuture();
    private UUID remoteLaunchId;
    private String remoteConsistentId;
    private ChannelHandlerContext ctx;
    private Channel channel;
    private HandshakeHandler handler;
    private long receivedCount;
    private final RecoveryDescriptorProvider recoveryDescriptorProvider;
    private RecoveryDescriptor recoveryDescriptor;

    public RecoveryServerHandshakeManager(UUID launchId, String consistentId, NetworkMessagesFactory messageFactory, RecoveryDescriptorProvider recoveryDescriptorProvider) {
        this.launchId = launchId;
        this.consistentId = consistentId;
        this.messageFactory = messageFactory;
        this.recoveryDescriptorProvider = recoveryDescriptorProvider;
    }

    @Override
    public void onInit(ChannelHandlerContext handlerContext) {
        this.ctx = handlerContext;
        this.channel = handlerContext.channel();
        this.handler = (HandshakeHandler)this.ctx.handler();
    }

    @Override
    public void onConnectionOpen() {
        HandshakeStartMessage handshakeStartMessage = this.messageFactory.handshakeStartMessage().launchId(this.launchId).consistentId(this.consistentId).build();
        ChannelFuture sendFuture = this.channel.writeAndFlush((Object)new OutNetworkObject(handshakeStartMessage, Collections.emptyList(), false));
        NettyUtils.toCompletableFuture(sendFuture).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.handshakeCompleteFuture.completeExceptionally(new HandshakeException("Failed to send handshake start message: " + throwable.getMessage(), (Throwable)throwable));
            }
        });
    }

    @Override
    public void onMessage(NetworkMessage message) {
        if (message instanceof HandshakeStartResponseMessage) {
            HandshakeStartResponseMessage msg = (HandshakeStartResponseMessage)message;
            this.remoteLaunchId = msg.launchId();
            this.remoteConsistentId = msg.consistentId();
            this.receivedCount = msg.receivedCount();
            this.recoveryDescriptor = this.recoveryDescriptorProvider.getRecoveryDescriptor(this.remoteConsistentId, this.remoteLaunchId, msg.connectionId(), true);
            this.handshake(this.recoveryDescriptor);
            return;
        }
        assert (this.recoveryDescriptor != null) : "Wrong server handshake flow";
        if (this.recoveryDescriptor.unacknowledgedCount() == 0) {
            this.finishHandshake();
        }
        this.ctx.fireChannelRead((Object)message);
    }

    private void handshake(RecoveryDescriptor descriptor) {
        PipelineUtils.afterHandshake(this.ctx.pipeline(), descriptor, this.createMessageHandler(), this.messageFactory);
        HandshakeFinishMessage response = this.messageFactory.handshakeFinishMessage().receivedCount(descriptor.receivedCount()).build();
        CompletableFuture<Object> sendFuture = NettyUtils.toCompletableFuture(this.channel.write((Object)new OutNetworkObject(response, Collections.emptyList(), false)));
        descriptor.acknowledge(this.receivedCount);
        int unacknowledgedCount = descriptor.unacknowledgedCount();
        if (unacknowledgedCount > 0) {
            CompletableFuture[] futs = new CompletableFuture[unacknowledgedCount + 1];
            futs[0] = sendFuture;
            List<OutNetworkObject> networkMessages = descriptor.unacknowledgedMessages();
            for (int i = 0; i < networkMessages.size(); ++i) {
                OutNetworkObject networkMessage = networkMessages.get(i);
                futs[i + 1] = NettyUtils.toCompletableFuture(this.channel.write((Object)networkMessage));
            }
            sendFuture = CompletableFuture.allOf(futs);
        }
        this.channel.flush();
        boolean hasUnacknowledgedMessages = unacknowledgedCount > 0;
        sendFuture.whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.handshakeCompleteFuture.completeExceptionally(new HandshakeException("Failed to send handshake response: " + throwable.getMessage(), (Throwable)throwable));
            } else if (!hasUnacknowledgedMessages) {
                this.finishHandshake();
            }
        });
    }

    private MessageHandler createMessageHandler() {
        return this.handler.createMessageHandler(this.remoteConsistentId);
    }

    @Override
    public CompletableFuture<NettySender> handshakeFuture() {
        return this.handshakeCompleteFuture;
    }

    private void finishHandshake() {
        this.ctx.pipeline().remove((ChannelHandler)this.handler);
        this.handshakeCompleteFuture.complete(new NettySender(this.channel, this.remoteLaunchId.toString(), this.remoteConsistentId));
    }

    @TestOnly
    public RecoveryDescriptor recoveryDescriptor() {
        return this.recoveryDescriptor;
    }
}

