/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class CastBytecodeExpression
extends BytecodeExpression {
    private static final ParameterizedType OBJECT_TYPE = ParameterizedType.type(Object.class);
    private final BytecodeExpression instance;

    CastBytecodeExpression(BytecodeExpression instance, ParameterizedType type) {
        super(type);
        this.instance = Objects.requireNonNull(instance, "instance is null");
        BytecodeUtils.checkArgument(type.getPrimitiveType() != Void.TYPE, "Type %s can not be cast to %s", instance.getType(), type);
        CastBytecodeExpression.generateBytecode(instance.getType(), this.getType());
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(CastBytecodeExpression.generateBytecode(this.instance.getType(), this.getType()));
    }

    private static BytecodeBlock generateBytecode(ParameterizedType sourceType, ParameterizedType targetType) {
        BytecodeBlock block = new BytecodeBlock();
        switch (CastBytecodeExpression.getTypeKind(sourceType)) {
            case PRIMITIVE: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        CastBytecodeExpression.castPrimitiveToPrimitive(block, sourceType.getPrimitiveType(), targetType.getPrimitiveType());
                        return block;
                    }
                    case BOXED_PRIMITVE: {
                        BytecodeUtils.checkArgument(sourceType.getPrimitiveType() == CastBytecodeExpression.unwrapPrimitiveType(targetType), "Type %s can not be cast to %s", sourceType, targetType);
                        return block.invokeStatic(targetType, "valueOf", targetType, sourceType);
                    }
                    case OTHER: {
                        BytecodeUtils.checkArgument(OBJECT_TYPE.equals(targetType), "Type %s can not be cast to %s", sourceType, targetType);
                        Class<?> sourceClass = sourceType.getPrimitiveType();
                        return block.invokeStatic(BytecodeUtils.wrap(sourceClass), "valueOf", BytecodeUtils.wrap(sourceClass), sourceClass).checkCast(targetType);
                    }
                }
            }
            case BOXED_PRIMITVE: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        BytecodeUtils.checkArgument(CastBytecodeExpression.unwrapPrimitiveType(sourceType) == targetType.getPrimitiveType(), "Type %s can not be cast to %s", sourceType, targetType);
                        return block.invokeVirtual(sourceType, targetType.getPrimitiveType().getSimpleName() + "Value", targetType, new ParameterizedType[0]);
                    }
                    case BOXED_PRIMITVE: {
                        BytecodeUtils.checkArgument(sourceType.equals(targetType), "Type %s can not be cast to %s", sourceType, targetType);
                        return block;
                    }
                    case OTHER: {
                        return block.checkCast(targetType);
                    }
                }
            }
            case OTHER: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        BytecodeUtils.checkArgument(OBJECT_TYPE.equals(sourceType), "Type %s can not be cast to %s", sourceType, targetType);
                        return block.checkCast(BytecodeUtils.wrap(targetType.getPrimitiveType())).invokeVirtual(BytecodeUtils.wrap(targetType.getPrimitiveType()), targetType.getPrimitiveType().getSimpleName() + "Value", targetType.getPrimitiveType(), new Class[0]);
                    }
                    case BOXED_PRIMITVE: 
                    case OTHER: {
                        return block.checkCast(targetType);
                    }
                }
            }
        }
        throw new UnsupportedOperationException("unexpected enum value");
    }

    private static BytecodeBlock castPrimitiveToPrimitive(BytecodeBlock block, Class<?> sourceType, Class<?> targetType) {
        if (sourceType == Boolean.TYPE && targetType == Boolean.TYPE) {
            return block;
        }
        if (sourceType == Byte.TYPE) {
            if (targetType == Byte.TYPE) {
                return block;
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Character.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Short.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Integer.TYPE) {
            if (targetType == Boolean.TYPE) {
                return block;
            }
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Long.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.L2I);
            }
            if (targetType == Long.TYPE) {
                return block;
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.L2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.L2D);
            }
        }
        if (sourceType == Float.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.F2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.F2L);
            }
            if (targetType == Float.TYPE) {
                return block;
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.F2D);
            }
        }
        if (sourceType == Double.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.D2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.D2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.D2F);
            }
            if (targetType == Double.TYPE) {
                return block;
            }
        }
        throw new IllegalArgumentException(String.format("Type %s can not be cast to %s", sourceType, targetType));
    }

    private static TypeKind getTypeKind(ParameterizedType type) {
        if (type.isPrimitive()) {
            return TypeKind.PRIMITIVE;
        }
        if (CastBytecodeExpression.unwrapPrimitiveType(type) != null) {
            return TypeKind.BOXED_PRIMITVE;
        }
        return TypeKind.OTHER;
    }

    private static Class<?> unwrapPrimitiveType(ParameterizedType boxedPrimitiveType) {
        switch (boxedPrimitiveType.getJavaClassName()) {
            case "java.lang.Boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    @Override
    protected String formatOneLine() {
        return "((" + this.getType().getSimpleName() + ") " + this.instance + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.instance);
    }

    private static enum TypeKind {
        PRIMITIVE,
        BOXED_PRIMITVE,
        OTHER;

    }
}

