/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class ColumnFamily {
    private final RocksDB db;
    private final String cfName;
    private final ColumnFamilyHandle cfHandle;

    private ColumnFamily(RocksDB db, ColumnFamilyHandle handle) throws RocksDBException {
        this.db = db;
        this.cfHandle = handle;
        this.cfName = new String(this.cfHandle.getName(), StandardCharsets.UTF_8);
    }

    public static ColumnFamily create(RocksDB db, ColumnFamilyDescriptor descriptor) throws RocksDBException {
        ColumnFamilyHandle cfHandle = db.createColumnFamily(descriptor);
        return new ColumnFamily(db, cfHandle);
    }

    public static ColumnFamily wrap(RocksDB db, ColumnFamilyHandle handle) throws RocksDBException {
        return new ColumnFamily(db, handle);
    }

    public void destroy() throws RocksDBException {
        this.db.dropColumnFamily(this.cfHandle);
        this.db.destroyColumnFamilyHandle(this.cfHandle);
    }

    public byte @Nullable [] get(byte @NotNull [] key) throws RocksDBException {
        return this.db.get(this.cfHandle, key);
    }

    public void put(byte @NotNull [] key, byte @NotNull [] value) throws RocksDBException {
        this.db.put(this.cfHandle, key, value);
    }

    public void put(WriteBatch batch, byte @NotNull [] key, byte @NotNull [] value) throws RocksDBException {
        batch.put(this.cfHandle, key, value);
    }

    public void delete(byte @NotNull [] key) throws RocksDBException {
        this.db.delete(this.cfHandle, key);
    }

    public void delete(WriteBatch batch, byte @NotNull [] key) throws RocksDBException {
        batch.delete(this.cfHandle, key);
    }

    public void deleteRange(byte[] start, byte[] end) throws RocksDBException {
        this.db.deleteRange(this.cfHandle, start, end);
    }

    public RocksIterator newIterator() {
        return this.db.newIterator(this.cfHandle);
    }

    public RocksIterator newIterator(ReadOptions options) {
        return this.db.newIterator(this.cfHandle, options);
    }

    public void ingestExternalFile(List<String> paths, IngestExternalFileOptions options) throws RocksDBException {
        this.db.ingestExternalFile(this.cfHandle, paths, options);
    }

    public ColumnFamilyHandle handle() {
        return this.cfHandle;
    }

    public String name() {
        return this.cfName;
    }

    public RocksDB db() {
        return this.db;
    }
}

