/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;

public interface IgniteSetOp
extends TraitsAwareIgniteRel {
    public boolean all();

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RelCollations.EMPTY))));
    }

    public int aggregateFieldsCount();

    default public RelOptCost computeSetOpCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double inputRows = 0.0;
        for (RelNode input : this.getInputs()) {
            inputRows += mq.getRowCount(input).doubleValue();
        }
        double mem = 0.5 * inputRows * (double)this.aggregateFieldsCount() * 4.0;
        return costFactory.makeCost(inputRows, inputRows * 1.0, 0.0, mem, 0.0);
    }

    public AggregateType aggregateType();
}

