/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.impl;

import java.util.List;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.storage.impl.LogStorageBudget;

public class EntryCountBudget
implements LogStorageBudget {
    private static final long NO_INDEX = -1L;
    private final long entriesCountLimit;
    private long firstIndex = -1L;
    private long lastIndex = -1L;

    public EntryCountBudget(long entriesCountLimit) {
        this.entriesCountLimit = entriesCountLimit;
    }

    @Override
    public boolean hasRoomFor(LogEntry entry) {
        return this.storedEntries() < this.entriesCountLimit;
    }

    private long storedEntries() {
        if (this.firstIndex == -1L && this.lastIndex == -1L) {
            return 0L;
        }
        if (this.firstIndex != -1L && this.lastIndex != -1L) {
            return this.lastIndex - this.firstIndex + 1L;
        }
        throw new IllegalStateException("Only one of firstIndex and lastIndex is initialized: " + this.firstIndex + " and " + this.lastIndex);
    }

    @Override
    public void onAppended(LogEntry entry) {
        if (this.firstIndex == -1L) {
            this.firstIndex = entry.getId().getIndex();
        }
        this.lastIndex = entry.getId().getIndex();
    }

    @Override
    public void onAppended(List<LogEntry> entries) {
        if (this.firstIndex == -1L) {
            this.firstIndex = entries.get(0).getId().getIndex();
        }
        this.lastIndex = entries.get(entries.size() - 1).getId().getIndex();
    }

    @Override
    public void onTruncatedPrefix(long firstIndexKept) {
        if (firstIndexKept <= this.lastIndex) {
            this.firstIndex = firstIndexKept;
        } else {
            this.clean();
        }
    }

    @Override
    public void onTruncatedSuffix(long lastIndexKept) {
        if (lastIndexKept >= this.firstIndex) {
            this.lastIndex = lastIndexKept;
        } else {
            this.clean();
        }
    }

    @Override
    public void onReset() {
        this.clean();
    }

    private void clean() {
        this.firstIndex = -1L;
        this.lastIndex = -1L;
    }
}

