/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.ignite.client.IgniteClientFeatureNotSupportedByServerException;
import org.apache.ignite.internal.client.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.apache.ignite.network.ClusterNode;

public class ProtocolContext {
    private final ProtocolVersion ver;
    private final Set<ProtocolBitmaskFeature> features;
    private final long serverIdleTimeout;
    private final ClusterNode clusterNode;

    public ProtocolContext(ProtocolVersion ver, EnumSet<ProtocolBitmaskFeature> features, long serverIdleTimeout, ClusterNode clusterNode) {
        this.ver = ver;
        this.features = Collections.unmodifiableSet(features != null ? features : EnumSet.noneOf(ProtocolBitmaskFeature.class));
        this.serverIdleTimeout = serverIdleTimeout;
        this.clusterNode = clusterNode;
    }

    public boolean isFeatureSupported(ProtocolBitmaskFeature feature) {
        return this.features.contains((Object)feature);
    }

    public void checkFeatureSupported(ProtocolBitmaskFeature feature) throws IgniteClientFeatureNotSupportedByServerException {
        if (!this.isFeatureSupported(feature)) {
            throw new IgniteClientFeatureNotSupportedByServerException(feature);
        }
    }

    public Set<ProtocolBitmaskFeature> features() {
        return this.features;
    }

    public ProtocolVersion version() {
        return this.ver;
    }

    public long serverIdleTimeout() {
        return this.serverIdleTimeout;
    }

    public ClusterNode clusterNode() {
        return this.clusterNode;
    }
}

