/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.client.ClientOperationType;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.client.IgniteClientConnectionException;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelConfiguration;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.HostAndPortRange;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.RetryPolicyContextImpl;
import org.apache.ignite.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.io.netty.NettyClientConnectionMultiplexer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;

public final class ReliableChannel
implements AutoCloseable {
    private final BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory;
    private volatile List<ClientChannelHolder> channels;
    private volatile int curChIdx = -1;
    private final IgniteClientConfiguration clientCfg;
    private final Map<String, ClientChannelHolder> nodeChannelsByName = new ConcurrentHashMap<String, ClientChannelHolder>();
    private final Map<String, ClientChannelHolder> nodeChannelsById = new ConcurrentHashMap<String, ClientChannelHolder>();
    private final AtomicBoolean scheduledChannelsReinit = new AtomicBoolean();
    private volatile boolean closed;
    private final ArrayList<Runnable> chFailLsnrs = new ArrayList();
    private final ReadWriteLock curChannelsGuard = new ReentrantReadWriteLock();
    private final ClientConnectionMultiplexer connMgr;
    private final IgniteLogger log;
    private volatile String[] prevHostAddrs;
    private final AtomicLong assignmentVersion = new AtomicLong();

    ReliableChannel(BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory, IgniteClientConfiguration clientCfg, IgniteLogger log) {
        this.clientCfg = Objects.requireNonNull(clientCfg, "clientCfg");
        this.chFactory = Objects.requireNonNull(chFactory, "chFactory");
        this.log = Objects.requireNonNull(log, "log");
        this.connMgr = new NettyClientConnectionMultiplexer();
        this.connMgr.start(clientCfg);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.connMgr.stop();
        List<ClientChannelHolder> holders = this.channels;
        if (holders != null) {
            for (ClientChannelHolder hld : holders) {
                hld.close();
            }
        }
    }

    public List<ClusterNode> connections() {
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(this.channels.size());
        for (ClientChannelHolder holder : this.nodeChannelsByName.values()) {
            ClientChannel ch = holder.ch;
            if (ch == null) continue;
            res.add(ch.protocolContext().clusterNode());
        }
        return res;
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadWriter payloadWriter, PayloadReader<T> payloadReader, String preferredNodeName, String preferredNodeId) {
        CompletableFuture fut = new CompletableFuture();
        this.handleServiceAsync(fut, opCode, payloadWriter, payloadReader, preferredNodeName, preferredNodeId, null, 0);
        return fut;
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadWriter payloadWriter, PayloadReader<T> payloadReader) {
        return this.serviceAsync(opCode, payloadWriter, payloadReader, null, null);
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadReader<T> payloadReader) {
        return this.serviceAsync(opCode, null, payloadReader, null, null);
    }

    private <T> void handleServiceAsync(CompletableFuture<T> fut, int opCode, PayloadWriter payloadWriter, PayloadReader<T> payloadReader, String preferredNodeName, String preferredNodeId, IgniteClientConnectionException failure, int attempt) {
        ClientChannel ch = null;
        ClientChannelHolder holder = null;
        if (preferredNodeName != null) {
            holder = this.nodeChannelsByName.get(preferredNodeName);
        } else if (preferredNodeId != null) {
            holder = this.nodeChannelsById.get(preferredNodeId);
        }
        if (holder != null) {
            try {
                ch = holder.getOrCreateChannel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ch == null) {
            try {
                ch = this.getDefaultChannel();
            }
            catch (Throwable ex) {
                if (failure != null) {
                    failure.addSuppressed(ex);
                    fut.completeExceptionally((Throwable)((Object)failure));
                    return;
                }
                fut.completeExceptionally(ex);
                return;
            }
        }
        ClientChannel ch0 = ch;
        ch0.serviceAsync(opCode, payloadWriter, payloadReader).handle((res, err) -> {
            if (err == null) {
                fut.complete(res);
                return null;
            }
            while (err instanceof CompletionException && err.getCause() != null) {
                err = err.getCause();
            }
            IgniteClientConnectionException failure0 = failure;
            if (err instanceof IgniteClientConnectionException) {
                IgniteClientConnectionException connectionErr = (IgniteClientConnectionException)((Object)((Object)err));
                try {
                    this.onChannelFailure(ch0);
                }
                catch (Throwable ex) {
                    fut.completeExceptionally(ex);
                    return null;
                }
                if (failure0 == null) {
                    failure0 = connectionErr;
                } else {
                    failure0.addSuppressed((Throwable)err);
                }
                if (this.shouldRetry(opCode, attempt, connectionErr, failure0)) {
                    this.log.debug("Going to retry request because of error [opCode={}, currentAttempt={}, errMsg={}]", (Throwable)((Object)failure0), new Object[]{opCode, attempt, failure0.getMessage()});
                    this.handleServiceAsync(fut, opCode, payloadWriter, payloadReader, null, null, failure0, attempt + 1);
                    return null;
                }
            } else {
                fut.completeExceptionally(err instanceof IgniteException ? new CompletionException((Throwable)err) : new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, err.getMessage(), err));
                return null;
            }
            fut.completeExceptionally((Throwable)((Object)failure0));
            return null;
        });
    }

    private static Map<InetSocketAddress, Integer> parsedAddresses(String[] addrs) {
        if (addrs == null || addrs.length == 0) {
            throw new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, "Empty addresses");
        }
        ArrayList<HostAndPortRange> ranges = new ArrayList<HostAndPortRange>(addrs.length);
        for (String a2 : addrs) {
            ranges.add(HostAndPortRange.parse(a2, 10800, 10900, "Failed to parse Ignite server address"));
        }
        return ranges.stream().flatMap(r -> IntStream.rangeClosed(r.portFrom(), r.portTo()).boxed().map(p -> InetSocketAddress.createUnresolved(r.host(), p))).collect(Collectors.toMap(a -> a, a -> 1, Integer::sum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentChannel(ClientChannelHolder hld) {
        this.curChannelsGuard.writeLock().lock();
        try {
            int idx = this.curChIdx;
            List<ClientChannelHolder> holders = this.channels;
            ClientChannelHolder dfltHld = holders.get(idx);
            if (dfltHld == hld) {
                this.curChIdx = ++idx >= holders.size() ? 0 : idx;
            }
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
    }

    private void onChannelFailure(ClientChannel ch) {
        this.onChannelFailure(this.channels.get(this.curChIdx), ch);
    }

    private void onChannelFailure(ClientChannelHolder hld, ClientChannel ch) {
        if (ch != null && ch == hld.ch) {
            hld.closeChannel();
        }
        this.chFailLsnrs.forEach(Runnable::run);
        this.rollCurrentChannel(hld);
        if (this.scheduledChannelsReinit.get()) {
            this.channelsInitAsync();
        }
    }

    public void addChannelFailListener(Runnable chFailLsnr) {
        this.chFailLsnrs.add(chFailLsnr);
    }

    private boolean shouldStopChannelsReinit() {
        return this.scheduledChannelsReinit.get() || this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean initChannelHolders() {
        List<ClientChannelHolder> holders = this.channels;
        this.scheduledChannelsReinit.set(false);
        Map<InetSocketAddress, Integer> newAddrs = null;
        if (this.clientCfg.addressesFinder() != null) {
            Object[] hostAddrs = this.clientCfg.addressesFinder().getAddresses();
            if (hostAddrs.length == 0) {
                throw new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, "Empty addresses");
            }
            if (!Arrays.equals(hostAddrs, this.prevHostAddrs)) {
                newAddrs = ReliableChannel.parsedAddresses((String[])hostAddrs);
                this.prevHostAddrs = hostAddrs;
            }
        } else if (holders == null) {
            newAddrs = ReliableChannel.parsedAddresses(this.clientCfg.addresses());
        }
        if (newAddrs == null) {
            return true;
        }
        HashMap<InetSocketAddress, ClientChannelHolder> curAddrs = new HashMap<InetSocketAddress, ClientChannelHolder>();
        HashSet<InetSocketAddress> allAddrs = new HashSet<InetSocketAddress>(newAddrs.keySet());
        if (holders != null) {
            for (int i = 0; i < holders.size(); ++i) {
                ClientChannelHolder h = holders.get(i);
                curAddrs.put(h.chCfg.getAddress(), h);
                allAddrs.add(h.chCfg.getAddress());
            }
        }
        ArrayList<ClientChannelHolder> reinitHolders = new ArrayList<ClientChannelHolder>();
        int dfltChannelIdx = -1;
        ClientChannelHolder currDfltHolder = null;
        int idx = this.curChIdx;
        if (idx != -1) {
            currDfltHolder = holders.get(idx);
        }
        for (InetSocketAddress addr : allAddrs) {
            int i;
            ClientChannelHolder hld;
            if (this.shouldStopChannelsReinit()) {
                return false;
            }
            if (!newAddrs.containsKey(addr)) {
                ((ClientChannelHolder)curAddrs.get(addr)).close();
                continue;
            }
            if (!curAddrs.containsKey(addr)) {
                hld = new ClientChannelHolder(new ClientChannelConfiguration(this.clientCfg, addr));
                for (i = 0; i < newAddrs.get(addr); ++i) {
                    reinitHolders.add(hld);
                }
                continue;
            }
            hld = (ClientChannelHolder)curAddrs.get(addr);
            for (i = 0; i < newAddrs.get(addr); ++i) {
                reinitHolders.add(hld);
            }
            if (hld != currDfltHolder) continue;
            dfltChannelIdx = reinitHolders.size() - 1;
        }
        if (dfltChannelIdx == -1) {
            dfltChannelIdx = 0;
        }
        this.curChannelsGuard.writeLock().lock();
        try {
            this.channels = reinitHolders;
            this.curChIdx = dfltChannelIdx;
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
        return true;
    }

    CompletableFuture<Void> channelsInitAsync() {
        if (!this.initChannelHolders()) {
            return CompletableFuture.completedFuture(null);
        }
        this.getDefaultChannel();
        this.initAllChannelsAsync();
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientChannel getDefaultChannel() {
        IgniteClientConnectionException failure = null;
        int attempt = 0;
        while (true) {
            ClientChannelHolder hld = null;
            ClientChannel c = null;
            try {
                if (this.closed) {
                    throw new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Channel is closed");
                }
                this.curChannelsGuard.readLock().lock();
                try {
                    hld = this.channels.get(this.curChIdx);
                }
                finally {
                    this.curChannelsGuard.readLock().unlock();
                }
                c = hld.getOrCreateChannel();
                if (c != null) {
                    return c;
                }
            }
            catch (IgniteClientConnectionException e) {
                if (failure == null) {
                    failure = e;
                } else {
                    failure.addSuppressed((Throwable)((Object)e));
                }
                this.onChannelFailure(hld, c);
                if (!this.shouldRetry(ClientOperationType.CHANNEL_CONNECT, attempt, e, failure)) break;
            }
            ++attempt;
        }
        throw new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Failed to connect", (Throwable)((Object)failure));
    }

    private boolean shouldRetry(int opCode, int iteration, IgniteClientConnectionException exception, IgniteClientConnectionException aggregateException) {
        ClientOperationType opType = ClientUtils.opCodeToClientOperationType(opCode);
        return this.shouldRetry(opType, iteration, exception, aggregateException);
    }

    private boolean shouldRetry(ClientOperationType opType, int iteration, IgniteClientConnectionException exception, IgniteClientConnectionException aggregateException) {
        if (opType == null) {
            return iteration < 16;
        }
        RetryPolicy plc = this.clientCfg.retryPolicy();
        if (plc == null) {
            return false;
        }
        RetryPolicyContextImpl ctx = new RetryPolicyContextImpl(this.clientCfg, opType, iteration, exception);
        try {
            return plc.shouldRetry(ctx);
        }
        catch (Throwable t) {
            aggregateException.addSuppressed(t);
            return false;
        }
    }

    private void initAllChannelsAsync() {
        ForkJoinPool.commonPool().submit(() -> {
            List<ClientChannelHolder> holders = this.channels;
            for (ClientChannelHolder hld : holders) {
                if (this.closed) {
                    return;
                }
                try {
                    hld.getOrCreateChannel(true);
                }
                catch (Exception exception) {}
            }
        });
    }

    private void onTopologyAssignmentChanged(ClientChannel clientChannel) {
        if (clientChannel == this.channels.get((int)this.curChIdx).ch) {
            this.assignmentVersion.incrementAndGet();
        }
    }

    public long partitionAssignmentVersion() {
        return this.assignmentVersion.get();
    }

    class ClientChannelHolder {
        private final ClientChannelConfiguration chCfg;
        private volatile ClientChannel ch;
        private volatile ClusterNode serverNode;
        private volatile boolean close;
        private final long[] reconnectRetries;

        private ClientChannelHolder(ClientChannelConfiguration chCfg) {
            this.chCfg = chCfg;
            this.reconnectRetries = chCfg.clientConfiguration().reconnectThrottlingRetries() > 0 && chCfg.clientConfiguration().reconnectThrottlingPeriod() > 0L ? new long[chCfg.clientConfiguration().reconnectThrottlingRetries()] : null;
        }

        private boolean applyReconnectionThrottling() {
            if (this.reconnectRetries == null) {
                return false;
            }
            long ts = System.currentTimeMillis();
            for (int i = 0; i < this.reconnectRetries.length; ++i) {
                if (ts - this.reconnectRetries[i] < this.chCfg.clientConfiguration().reconnectThrottlingPeriod()) continue;
                this.reconnectRetries[i] = ts;
                return false;
            }
            return true;
        }

        private ClientChannel getOrCreateChannel() {
            return this.getOrCreateChannel(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientChannel getOrCreateChannel(boolean ignoreThrottling) {
            if (this.ch == null && !this.close) {
                ClientChannelHolder clientChannelHolder = this;
                synchronized (clientChannelHolder) {
                    if (this.close) {
                        return null;
                    }
                    if (this.ch != null) {
                        return this.ch;
                    }
                    if (!ignoreThrottling && this.applyReconnectionThrottling()) {
                        throw new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Reconnect is not allowed due to applied throttling");
                    }
                    this.ch = ReliableChannel.this.chFactory.apply(this.chCfg, ReliableChannel.this.connMgr);
                    this.ch.addTopologyAssignmentChangeListener(x$0 -> ReliableChannel.this.onTopologyAssignmentChanged((ClientChannel)x$0));
                    ClusterNode newNode = this.ch.protocolContext().clusterNode();
                    ReliableChannel.this.nodeChannelsByName.put(newNode.name(), this);
                    ReliableChannel.this.nodeChannelsById.put(newNode.id(), this);
                    ClusterNode oldServerNode = this.serverNode;
                    if (oldServerNode != null && !oldServerNode.id().equals(newNode.id())) {
                        ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
                        ReliableChannel.this.nodeChannelsById.remove(oldServerNode.id(), this);
                    }
                    this.serverNode = newNode;
                }
            }
            return this.ch;
        }

        private synchronized void closeChannel() {
            if (this.ch != null) {
                try {
                    this.ch.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ClusterNode oldServerNode = this.serverNode;
                if (oldServerNode != null) {
                    ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
                    ReliableChannel.this.nodeChannelsById.remove(oldServerNode.id(), this);
                }
                this.ch = null;
            }
        }

        void close() {
            this.close = true;
            ClusterNode oldServerNode = this.serverNode;
            if (oldServerNode != null) {
                ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
                ReliableChannel.this.nodeChannelsById.remove(oldServerNode.id(), this);
            }
            this.closeChannel();
        }
    }
}

