/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaBuilder;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaOutter;

public class LocalFileMetaImpl
implements LocalFileMetaOutter.LocalFileMeta {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2002;
    @IgniteToStringInclude
    private final String checksum;
    @IgniteToStringInclude
    private final boolean hasUserMeta;
    @IgniteToStringInclude
    private LocalFileMetaOutter.FileSource source;
    private byte[] sourceByteArray;

    private LocalFileMetaImpl(String checksum, boolean hasUserMeta, LocalFileMetaOutter.FileSource source, byte[] sourceByteArray) {
        this.checksum = checksum;
        this.hasUserMeta = hasUserMeta;
        this.source = source;
        this.sourceByteArray = sourceByteArray;
    }

    @Override
    public String checksum() {
        return this.checksum;
    }

    @Override
    public boolean hasUserMeta() {
        return this.hasUserMeta;
    }

    byte[] sourceByteArray() {
        return this.sourceByteArray;
    }

    @Override
    public LocalFileMetaOutter.FileSource source() {
        return this.source;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(LocalFileMetaImpl.class, (Object)this);
    }

    public short messageType() {
        return 2002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalFileMetaImpl otherMessage = (LocalFileMetaImpl)other;
        return Objects.equals(this.checksum, otherMessage.checksum) && Objects.equals((Object)this.source, (Object)otherMessage.source) && this.hasUserMeta == otherMessage.hasUserMeta;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.hasUserMeta, this.checksum, this.source});
        return result;
    }

    public static LocalFileMetaBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject sourceByteArraymo = marshaller.marshal((Object)this.source);
        usedDescriptors.addAll((IntCollection)sourceByteArraymo.usedDescriptorIds());
        this.sourceByteArray = sourceByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.source = (LocalFileMetaOutter.FileSource)((Object)marshaller.unmarshal(this.sourceByteArray, descriptorsObj));
        this.sourceByteArray = null;
    }

    private static class Builder
    implements LocalFileMetaBuilder {
        private String checksum;
        private boolean hasUserMeta;
        private LocalFileMetaOutter.FileSource source;
        private byte[] sourceByteArray;

        private Builder() {
        }

        @Override
        public LocalFileMetaBuilder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public LocalFileMetaBuilder hasUserMeta(boolean hasUserMeta) {
            this.hasUserMeta = hasUserMeta;
            return this;
        }

        @Override
        public LocalFileMetaBuilder source(LocalFileMetaOutter.FileSource source) {
            this.source = source;
            return this;
        }

        @Override
        public LocalFileMetaBuilder sourceByteArray(byte[] sourceByteArray) {
            this.sourceByteArray = sourceByteArray;
            return this;
        }

        @Override
        public String checksum() {
            return this.checksum;
        }

        @Override
        public boolean hasUserMeta() {
            return this.hasUserMeta;
        }

        @Override
        public LocalFileMetaOutter.FileSource source() {
            return this.source;
        }

        @Override
        public byte[] sourceByteArray() {
            return this.sourceByteArray;
        }

        @Override
        public LocalFileMetaOutter.LocalFileMeta build() {
            return new LocalFileMetaImpl(this.checksum, this.hasUserMeta, this.source, this.sourceByteArray);
        }
    }
}

