/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessageImpl;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageSerializer;
import org.apache.ignite.network.serialization.MessageWriter;

class ClusterNodeMessageSerializer
implements MessageSerializer<ClusterNodeMessage> {
    ClusterNodeMessageSerializer() {
    }

    public boolean writeMessage(ClusterNodeMessage msg, MessageWriter writer) throws MessageMappingException {
        ClusterNodeMessageImpl message = (ClusterNodeMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("host", message.host());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("id", message.id());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("name", message.name());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeInt("port", message.port());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

