/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.log;

import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.PushMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.LogPushExporterView;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.shaded.com.google.auto.service.AutoService;

@AutoService(value={MetricExporter.class})
public class LogPushExporter
extends PushMetricExporter<LogPushExporterView> {
    public static final String EXPORTER_NAME = "logPush";

    @Override
    protected long period() {
        return ((LogPushExporterView)this.configuration()).period();
    }

    @Override
    public void report() {
        if (CollectionUtils.nullOrEmpty(this.metrics().get1().values())) {
            return;
        }
        StringBuilder report = new StringBuilder("Metric report: \n");
        for (MetricSet metricSet : this.metrics().get1().values()) {
            report.append(metricSet.name()).append(":\n");
            StreamSupport.stream(metricSet.spliterator(), false).sorted(Comparator.comparing(Metric::name)).forEach(metric -> report.append(metric.name()).append(':').append(metric.getValueAsString()).append('\n'));
        }
        this.log.info(report.toString(), new Object[0]);
    }

    @Override
    public String name() {
        return EXPORTER_NAME;
    }
}

