/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SlidingHistogram {
    private static final int BUCKET_COUNT = 500;
    private final AtomicIntegerArray bucketCounters = new AtomicIntegerArray(500);
    private final int[] circularBuffer;
    private final int windowSize;
    private final long estimationDefault;
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private volatile int index = 0;

    public SlidingHistogram(int windowSize, long estimationDefault) {
        this.windowSize = windowSize;
        this.estimationDefault = estimationDefault;
        this.circularBuffer = new int[windowSize];
    }

    public synchronized void record(long value) {
        int bucket = SlidingHistogram.mapToBucket(value);
        int index = this.index;
        this.index = (index + 1) % this.windowSize;
        if (this.currentSize.get() == this.windowSize) {
            int oldBucket = this.circularBuffer[index];
            this.bucketCounters.decrementAndGet(oldBucket);
        } else {
            this.currentSize.incrementAndGet();
        }
        this.circularBuffer[index] = bucket;
        this.bucketCounters.incrementAndGet(bucket);
    }

    public synchronized long estimatePercentile(double percentile) {
        if (this.currentSize.get() < this.windowSize) {
            return this.estimationDefault;
        }
        int target = (int)Math.ceil((double)this.windowSize * percentile);
        int cumulative = 0;
        for (int i = 0; i < 500; ++i) {
            if ((cumulative += this.bucketCounters.get(i)) < target) continue;
            return SlidingHistogram.estimateValueFromBucket(i);
        }
        return SlidingHistogram.estimateValueFromBucket(499);
    }

    private static int mapToBucket(long value) {
        if (value <= 0L) {
            return 0;
        }
        long b = SlidingHistogram.mappingFunc(value);
        return (int)Math.min(b, 498L);
    }

    private static long estimateValueFromBucket(int bucket) {
        int nextBucket = bucket + 1;
        if (nextBucket == 499) {
            return Long.MAX_VALUE;
        }
        return SlidingHistogram.mappingFuncReverse(nextBucket);
    }

    private static long mappingFunc(long value) {
        return (long)Math.sqrt(value);
    }

    private static long mappingFuncReverse(long value) {
        return value * value;
    }
}

