/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryEditor;

public class AddPointOperation
extends GeometryEditor.CoordinateOperation {
    private final Geometry point;
    private final int index;

    public AddPointOperation(Geometry point, int index) {
        this.point = point;
        this.index = index;
    }

    public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
        int i;
        if (this.index < 0 || this.index > coordinates.length) {
            throw new IllegalArgumentException("Invalid index: " + this.index);
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length + 1];
        for (i = 0; i < this.index; ++i) {
            newCoordinates[i] = (Coordinate)coordinates[i].clone();
        }
        newCoordinates[this.index] = this.point.getCoordinate();
        for (i = this.index; i < coordinates.length; ++i) {
            newCoordinates[i + 1] = (Coordinate)coordinates[i].clone();
        }
        return newCoordinates;
    }
}

