/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc.tags;

import com.github.chhorz.javadoc.exception.InvalidCapturingGroupName;
import com.github.chhorz.javadoc.tags.Tag;
import java.util.List;
import java.util.Objects;

public interface BlockTag
extends Tag {
    public List<Segment> getSegments();

    public void putValue(String var1, String var2);

    public String createPattern(String var1);

    public static class Segment {
        public static final String SEGMENT_NAME_PATTERN = "[a-zA-Z]\\w*";
        private final String segmentName;
        private final boolean required;

        public Segment(String name) {
            this(name, true);
        }

        public Segment(String segmentName, boolean required) {
            Objects.requireNonNull(segmentName, "The segment name must not be null");
            this.segmentName = segmentName;
            this.required = required;
            if (!segmentName.matches(SEGMENT_NAME_PATTERN)) {
                throw new InvalidCapturingGroupName(segmentName);
            }
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return String.format("Segment [name=%s, required=%s]", this.segmentName, this.required);
        }
    }
}

