/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsResizeHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesFromURLHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.PageBlobCopyIncrementalRequestConditions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.options.PageBlobCopyIncrementalOptions;
import com.azure.storage.blob.options.PageBlobCreateOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SpecializedBlobClientBuilder.class, isAsync=true)
public final class PageBlobAsyncClient
extends BlobAsyncClientBase {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;
    private final ClientLogger logger = new ClientLogger(PageBlobAsyncClient.class);

    PageBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    @Override
    public PageBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new PageBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public PageBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new PageBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.getStart() < 0L || pageRange.getEnd() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.getStart() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.getEnd() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.getEnd() <= pageRange.getStart()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.getStart() + '-' + pageRange.getEnd();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> create(long size) {
        try {
            return this.create(size, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> create(long size, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.createWithResponse(size, null, null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions) {
        return this.createWithResponse(new PageBlobCreateOptions(size).setSequenceNumber(sequenceNumber).setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> createWithResponse(PageBlobCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> createWithResponse(PageBlobCreateOptions options, Context context) {
        BlobRequestConditions requestConditions;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobRequestConditions blobRequestConditions = requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        if (options.getSize() % 512L != 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        if (options.getSequenceNumber() != null && options.getSequenceNumber() < 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().createWithResponseAsync(this.containerName, this.blobName, 0L, options.getSize(), null, null, options.getMetadata(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), options.getSequenceNumber(), null, this.tagsToString(options.getTags()), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsCreateHeaders hd = (PageBlobsCreateHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null, hd.getXMsVersionId());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> uploadPages(PageRange pageRange, Flux<ByteBuffer> body) {
        try {
            return this.uploadPagesWithResponse(pageRange, body, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesWithResponse(pageRange, body, contentMd5, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().uploadPagesWithResponseAsync(this.containerName, this.blobName, pageRange.getEnd() - pageRange.getStart() + 1L, body, contentMd5, null, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), pageBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsUploadPagesHeaders hd = (PageBlobsUploadPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> uploadPagesFromUrl(PageRange range, String sourceUrl, Long sourceOffset) {
        try {
            return this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, sourceContentMd5, destRequestConditions, sourceRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Context context) {
        URL url;
        if (range == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("range cannot be null."));
        }
        String rangeString = PageBlobAsyncClient.pageRangeToString(range);
        if (sourceOffset == null) {
            sourceOffset = 0L;
        }
        String sourceRangeString = PageBlobAsyncClient.pageRangeToString(new PageRange().setStart(sourceOffset).setEnd(sourceOffset + (range.getEnd() - range.getStart())));
        destRequestConditions = destRequestConditions == null ? new PageBlobRequestConditions() : destRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new BlobRequestConditions() : sourceRequestConditions;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().uploadPagesFromURLWithResponseAsync(this.containerName, this.blobName, url, sourceRangeString, 0L, rangeString, sourceContentMd5, null, null, destRequestConditions.getLeaseId(), destRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), destRequestConditions.getIfSequenceNumberLessThan(), destRequestConditions.getIfSequenceNumberEqualTo(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getTagsConditions(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsUploadPagesFromURLHeaders hd = (PageBlobsUploadPagesFromURLHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null);
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> clearPages(PageRange pageRange) {
        try {
            return this.clearPagesWithResponse(pageRange, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.clearPagesWithResponse(pageRange, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().clearPagesWithResponseAsync(this.containerName, this.blobName, 0L, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), pageBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsClearPagesHeaders hd = (PageBlobsClearPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getPageRanges(BlobRange blobRange) {
        try {
            return this.getPageRangesWithResponse(blobRange, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesWithResponse(blobRange, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().getPageRangesWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        try {
            return this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getManagedDiskPageRangesDiff(BlobRange blobRange, String prevSnapshotUrl) {
        try {
            return this.getManagedDiskPageRangesDiffWithResponse(blobRange, prevSnapshotUrl, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getManagedDiskPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshotUrl, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, null, prevSnapshotUrl, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, String prevSnapshotUrl, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        URL url = null;
        if (prevSnapshotUrl == null && prevSnapshot == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("prevSnapshot cannot be null"));
        }
        if (prevSnapshotUrl != null) {
            try {
                url = new URL(prevSnapshotUrl);
            }
            catch (MalformedURLException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'prevSnapshotUrl' is not a valid url."));
            }
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, prevSnapshot, url, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> resize(long size) {
        try {
            return this.resizeWithResponse(size, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.resizeWithResponse(size, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions, Context context) {
        if (size % 512L != 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().resizeWithResponseAsync(this.containerName, this.blobName, size, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsResizeHeaders hd = (PageBlobsResizeHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        try {
            return this.updateSequenceNumberWithResponse(action, sequenceNumber, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.updateSequenceNumberWithResponse(action, sequenceNumber, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions, Context context) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        sequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().updateSequenceNumberWithResponseAsync(this.containerName, this.blobName, action, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), sequenceNumber, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            PageBlobsUpdateSequenceNumberHeaders hd = (PageBlobsUpdateSequenceNumberHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyStatusType> copyIncremental(String source, String snapshot) {
        try {
            return this.copyIncrementalWithResponse(source, snapshot, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyStatusType>> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions) {
        try {
            return this.copyIncrementalWithResponse(new PageBlobCopyIncrementalOptions(source, snapshot).setRequestConditions(ModelHelper.populateBlobDestinationRequestConditions(modifiedRequestConditions)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyStatusType>> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options) {
        try {
            return FluxUtil.withContext(context -> this.copyIncrementalWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CopyStatusType>> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options, Context context) {
        URL url;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        UrlBuilder builder = UrlBuilder.parse((String)options.getSource());
        builder.setQueryParameter("snapshot", options.getSnapshot());
        PageBlobCopyIncrementalRequestConditions modifiedRequestConditions = options.getRequestConditions() == null ? new PageBlobCopyIncrementalRequestConditions() : options.getRequestConditions();
        try {
            url = builder.toUrl();
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(e));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().copyIncrementalWithResponseAsync(this.containerName, this.blobName, url, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), modifiedRequestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((PageBlobsCopyIncrementalHeaders)rb.getDeserializedHeaders()).getXMsCopyStatus()));
    }
}

