/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MvccCoordinator
implements Serializable {
    public static final MvccCoordinator DISCONNECTED_COORDINATOR = new MvccCoordinator(AffinityTopologyVersion.NONE, null, 0L, false);
    public static final MvccCoordinator UNASSIGNED_COORDINATOR = new MvccCoordinator(AffinityTopologyVersion.NONE, null, 0L, false);
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final AffinityTopologyVersion topVer;
    private final UUID nodeId;
    private final long ver;
    private final boolean local;
    private volatile boolean initialized;

    public MvccCoordinator(AffinityTopologyVersion topVer, UUID nodeId, long ver, boolean local) {
        this.topVer = topVer;
        this.nodeId = nodeId;
        this.ver = ver;
        this.local = local;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long version() {
        return this.ver;
    }

    public boolean local() {
        return this.local;
    }

    public boolean disconnected() {
        return this == DISCONNECTED_COORDINATOR;
    }

    public boolean unassigned() {
        return this == UNASSIGNED_COORDINATOR;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void initialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MvccCoordinator that = (MvccCoordinator)o;
        return this.ver == that.ver;
    }

    public int hashCode() {
        return (int)(this.ver ^ this.ver >>> 32);
    }

    public String toString() {
        return S.toString(MvccCoordinator.class, this);
    }
}

