/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheClearTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheClearTaskResult;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;

@GridInternal
@GridVisorManagementTask
public class VisorCacheClearTask
extends VisorOneNodeTask<VisorCacheClearTaskArg, VisorCacheClearTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheClearJob job(VisorCacheClearTaskArg arg) {
        return new VisorCacheClearJob(arg, this.debug);
    }

    private static class VisorCacheClearJob
    extends VisorJob<VisorCacheClearTaskArg, VisorCacheClearTaskResult> {
        private static final long serialVersionUID = 0L;
        private final IgniteInClosure<IgniteFuture> lsnr = new IgniteInClosure<IgniteFuture>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void apply(IgniteFuture f) {
                assert (futs[0].isDone());
                assert (futs[1] == null || futs[1].isDone());
                assert (futs[2] == null || futs[2].isDone());
                jobCtx.callcc();
            }
        };
        private IgniteFuture<Long>[] futs;
        @JobContextResource
        private ComputeJobContext jobCtx;

        private VisorCacheClearJob(VisorCacheClearTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private boolean callAsync(IgniteFuture fut) {
            if (fut.isDone()) {
                return false;
            }
            this.jobCtx.holdcc();
            fut.listen(this.lsnr);
            return true;
        }

        @Override
        protected VisorCacheClearTaskResult run(VisorCacheClearTaskArg arg) {
            if (this.futs == null) {
                this.futs = new IgniteFuture[3];
            }
            if (this.futs[0] == null || this.futs[1] == null || this.futs[2] == null) {
                String cacheName = arg.getCacheName();
                IgniteCache cache = this.ignite.cache(cacheName);
                if (cache == null) {
                    throw new IllegalStateException("Failed to find cache for name: " + cacheName);
                }
                if (this.futs[0] == null) {
                    this.futs[0] = cache.sizeLongAsync(CachePeekMode.PRIMARY);
                    if (this.callAsync(this.futs[0])) {
                        return null;
                    }
                }
                if (this.futs[1] == null) {
                    this.futs[1] = cache.clearAsync();
                    if (this.callAsync(this.futs[1])) {
                        return null;
                    }
                }
                if (this.futs[2] == null) {
                    this.futs[2] = cache.sizeLongAsync(CachePeekMode.PRIMARY);
                    if (this.callAsync(this.futs[2])) {
                        return null;
                    }
                }
            }
            assert (this.futs[0].isDone() && this.futs[1].isDone() && this.futs[2].isDone());
            return new VisorCacheClearTaskResult(this.futs[0].get(), this.futs[2].get());
        }

        public String toString() {
            return S.toString(VisorCacheClearJob.class, this);
        }
    }
}

