/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.base.reteoo;

import org.drools.base.common.NetworkNode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.util.bitmask.BitMask;

public interface BaseTerminalNode extends NetworkNode {
    Declaration[] getAllDeclarations();

    Declaration[] getRequiredDeclarations();

    Declaration[] getSalienceDeclarations();

    void initInferredMask();

    BitMask getDeclaredMask();

    void setDeclaredMask(BitMask mask);

    BitMask getInferredMask();

    void setInferredMask(BitMask mask);

    BitMask getNegativeMask();

    void setNegativeMask(BitMask mask);

    RuleImpl getRule();

    GroupElement getSubRule();

    boolean isFireDirect();

    int getSubruleIndex();
}
