<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

### DMN Marshaller backend compatibility tester

The scope of this module is to provide a reliable scripting mechanism that tests DMN Files generated by the `dmn-marshaller` package against the backend counterpart code that lives in the drools repository.
The scripts are based on [JBang!](https://www.jbang.dev/) which provides an out-of-the-box library to be consumed in NodeJs.

At the moment of writing, two scripts are available:

- DMN Validation, which can validate a DMN file (and its imported DMN assets) using the [KIE DMN Validator](https://github.com/apache/incubator-kie-drools/tree/main/kie-dmn/kie-dmn-validation) back-end module.
- DMN Semantic Comparison, which compares two DMN files (and their imported DMN assets) using a Backend logic that relies on KIE DMN Engine core code.

Every script is defined in a single Java class. Inside those, you can find a list of fields (marked with `@Option` annotation) that represent the commands and their required parameters to run the scripts.

An abstract class is defined as the parent class of all defined scripts. That class holds all the Dependencies required by all the Java class scripts that implement it. This is required to enable a dependency fetching mechanism useful for:

- Avoid issues when launching several JBang instances. This case may lead to issues with internal JBang caching.
- In CI/CD, it's sometimes required to download all the required dependencies in an earlier phase and then build the project.
  To run the dependency fetching mechanism, you can just launch the jbang command passing that Abstract class location (no args).
  To keep this mechanism consistent, please always declare all the required dependencies in the abstract superclass.
  The dependency fetching mechanism can be called externally from a `package.json` script using the `dependenciesFetch.js` file, using the following command:
  `node dist/dependenciesFetch.js`.
  It's not possible to directly call JBang in the package.json script because when the JBang NPM library installs JBang in the local machine with the preinstall hook, it requires a new Shell for changes to take effect.

### Usage

The entry point of this module is the `index.js` file that exports:

- `executeJBangScript` that requires as parameters: the Script to execute (see below) and its required args.
- The enumeration of the currently available Script
  That represents all the required elements for consuming this module externally.

To execute a specific JBang script present in this module you must:

- Import the `"@kie-tools/dmn-marshaller-backend-compatibility-tester"` dependency;
- Import the required function (eg.`executeDMNValidation` or `executeDMNSemanticComparison`) in your JS/TS file;
- Call one of the above function passing its required parameters.
- For the precise args list, please check inside the Java Class Script of your interest and take note of all `@Option` annotated fields.

---

Apache KIE (incubating) is an effort undergoing incubation at The Apache Software
Foundation (ASF), sponsored by the name of Apache Incubator. Incubation is
required of all newly accepted projects until a further review indicates that
the infrastructure, communications, and decision making process have stabilized
in a manner consistent with other successful ASF projects. While incubation
status is not necessarily a reflection of the completeness or stability of the
code, it does indicate that the project has yet to be fully endorsed by the ASF.

Some of the incubating project’s releases may not be fully compliant with ASF
policy. For example, releases may have incomplete or un-reviewed licensing
conditions. What follows is a list of known issues the project is currently
aware of (note that this list, by definition, is likely to be incomplete):

- Hibernate, an LGPL project, is being used. Hibernate is in the process of
  relicensing to ASL v2
- Some files, particularly test files, and those not supporting comments, may
  be missing the ASF Licensing Header

If you are planning to incorporate this work into your product/project, please
be aware that you will need to conduct a thorough licensing review to determine
the overall implications of including this work. For the current status of this
project through the Apache Incubator visit:
https://incubator.apache.org/projects/kie.html
