import type KieSandboxFs from "@kie-tools/kie-sandbox-fs";
export declare class LfsStorageFile {
    private readonly args;
    constructor(args: {
        path: string;
        getFileContents: () => Promise<Uint8Array>;
    });
    get path(): string;
    get getFileContents(): () => Promise<Uint8Array>;
}
export declare class LfsStorageService {
    createOrOverwriteFile(fs: KieSandboxFs, file: LfsStorageFile): Promise<void>;
    updateFile(fs: KieSandboxFs, file: LfsStorageFile): Promise<void>;
    deleteFile(fs: KieSandboxFs, path: string): Promise<void>;
    renameFile(fs: KieSandboxFs, file: LfsStorageFile, newFileName: string): Promise<LfsStorageFile>;
    getFile(fs: KieSandboxFs, path: string): Promise<LfsStorageFile | undefined>;
    mkdirDeep(fs: KieSandboxFs, dirPath: string, _selfCall?: boolean): Promise<void>;
    exists(fs: KieSandboxFs, path: string): Promise<boolean>;
    createFiles(fs: KieSandboxFs, files: LfsStorageFile[]): Promise<void>;
    walk<T = string>(args: {
        fs: KieSandboxFs;
        startFromDirPath: string;
        shouldExcludeDir: (dirPath: string) => boolean;
        onVisit: (args: {
            absolutePath: string;
            relativePath: string;
        }) => Promise<T | undefined>;
        originalStartingDirPath?: string;
    }): Promise<T[]>;
    getFiles(fs: KieSandboxFs, paths: string[]): Promise<LfsStorageFile[]>;
}
//# sourceMappingURL=LfsStorageService.d.ts.map