"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspacesWorkerApiImpl = void 0;
var api_1 = require("@kie-tools-core/workspace/dist/api");
var path_1 = require("path");
var GitConstants_1 = require("../constants/GitConstants");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var GitService_1 = require("../services/GitService");
var StorageService_1 = require("../services/StorageService");
var WorkspaceOrigin_1 = require("./api/WorkspaceOrigin");
var WorkspacesWorkerApiImpl = (function () {
    function WorkspacesWorkerApiImpl(args) {
        this.args = args;
        this.MAX_NEW_FILE_INDEX_ATTEMPTS = 10;
        this.NEW_FILE_DEFAULT_NAME = "Untitled";
        this.GIT_DEFAULT_USER = {
            name: this.args.appName,
            email: "",
        };
    }
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_changeGitAuthSessionId = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.changeGitAuthSessionId(fs, args.workspaceId, args.gitAuthSessionId, args.insecurelyDisableTlsCertificateValidation);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_initGistOnExistingWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.turnIntoGist(fs, args.workspaceId, new URL(args.remoteUrl), args.branch, args.insecurelyDisableTlsCertificateValidation);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_initSnippetOnExistingWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.turnIntoSnippet(fs, args.workspaceId, new URL(args.remoteUrl), args.branch, args.insecurelyDisableTlsCertificateValidation);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_initGitOnExistingWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.turnIntoGit(fs, args.workspaceId, new URL(args.remoteUrl), args.branch, args.insecurelyDisableTlsCertificateValidation);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_initLocalOnExistingWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.turnIntoLocal(fs, args.workspaceId);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_getWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadonlyInMemoryFs(function (_a) {
                        var fs = _a.fs;
                        return _this.args.services.descriptorService.get(fs, args.workspaceId);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_listAllWorkspaces = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.descriptorsFsService.withReadonlyInMemoryFs(function (_a) {
                        var fs = _a.fs, schema = _a.schema;
                        return _this.args.services.descriptorService.listAll(fs, schema);
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_resourceContentGet = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var file;
                        var _c;
                        var fs = _b.fs;
                        return __generator(this, function (_d) {
                            switch (_d.label) {
                                case 0: return [4, this.args.services.workspaceService.getFile({
                                        fs: fs,
                                        workspaceId: args.workspaceId,
                                        relativePath: args.relativePath,
                                    })];
                                case 1:
                                    file = _d.sent();
                                    if (!file) {
                                        throw new Error("File '".concat(args.relativePath, "' not found in Workspace ").concat(args.workspaceId));
                                    }
                                    try {
                                        if (((_c = args.opts) === null || _c === void 0 ? void 0 : _c.type) === "binary") {
                                            return [2, new api_1.ResourceContent(args.relativePath, file.content ? Buffer.from(file.content).toString("base64") : "", "binary")];
                                        }
                                        return [2, new api_1.ResourceContent(args.relativePath, EncoderDecoder_1.decoder.decode(file.content), "text")];
                                    }
                                    catch (e) {
                                        console.error(e);
                                        throw e;
                                    }
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_resourceContentList = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyFsSchema(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var files;
                        var schema = _b.schema;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.workspaceService.getFilteredWorkspaceFileDescriptors(schema, args.workspaceId, args.globPattern)];
                                case 1:
                                    files = _c.sent();
                                    return [2, new api_1.ResourcesList(args.globPattern, files.map(function (file) { return file.relativePath; }))];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_addEmptyFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.kieSandboxWorkspacesStorage_addFile(__assign(__assign({}, args), { name: this.NEW_FILE_DEFAULT_NAME, content: "" }))];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_addFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var i, index, fileName, relativePath, newFile;
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0:
                                    i = 0;
                                    _c.label = 1;
                                case 1:
                                    if (!(i < this.MAX_NEW_FILE_INDEX_ATTEMPTS)) return [3, 5];
                                    index = i === 0 ? "" : "-".concat(i);
                                    fileName = "".concat(args.name).concat(index).concat(args.extension ? "." : "").concat(args.extension);
                                    relativePath = (0, path_1.join)(args.destinationDirRelativePath, fileName);
                                    return [4, this.args.services.workspaceService.existsFile({ fs: fs, workspaceId: args.workspaceId, relativePath: relativePath })];
                                case 2:
                                    if (_c.sent()) {
                                        return [3, 4];
                                    }
                                    newFile = {
                                        workspaceId: args.workspaceId,
                                        content: EncoderDecoder_1.encoder.encode(args.content),
                                        relativePath: relativePath,
                                    };
                                    return [4, this.args.services.workspaceService.createOrOverwriteFile(fs, newFile, broadcaster)];
                                case 3:
                                    _c.sent();
                                    return [2, newFile];
                                case 4:
                                    i++;
                                    return [3, 1];
                                case 5: throw new Error("Max attempts of new empty file exceeded.");
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_deleteFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.wwfd.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.workspaceService.deleteFile(fs, args.wwfd, broadcaster)];
                                case 1:
                                    _c.sent();
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_moveFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.wwfd.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.workspaceService.moveFile({
                                    fs: fs,
                                    wwfd: args.wwfd,
                                    newDirPath: args.newDirPath,
                                    broadcaster: broadcaster,
                                })];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_deleteWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.services.workspaceService.delete(args.workspaceId)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_existsFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyFsSchema(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var schema = _b.schema;
                        return __generator(this, function (_c) {
                            return [2, !!schema.get(this.args.services.workspaceService.getAbsolutePath(args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_getFile = function (args) {
        var _this = this;
        return this.args.services.workspaceFsService.withReadonlyFsSchema(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
            var schema = _b.schema;
            return __generator(this, function (_c) {
                return [2, (schema.get(this.args.services.workspaceService.getAbsolutePath(args)) && {
                        workspaceId: args.workspaceId,
                        relativePath: args.relativePath,
                    })];
            });
        }); });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_getFileContent = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.storageService.getFileContent(fs, this.args.services.workspaceService.getAbsolutePath(args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_getFiles = function (args) {
        var _this = this;
        return this.args.services.workspaceFsService.withReadonlyFsSchema(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
            var schema = _b.schema;
            return __generator(this, function (_c) {
                return [2, this.args.services.workspaceService.getFilteredWorkspaceFileDescriptors(schema, args.workspaceId, args.globPattern)];
            });
        }); });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_getUniqueFileIdentifier = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceService.getUniqueFileIdentifier(args)];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_prepareZip = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, schema = _b.schema;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.workspaceService.prepareZip(fs, schema, args.workspaceId, args.onlyExtensions, args.globPattern)];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_renameFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.wwfd.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.workspaceService.renameFile({
                                    fs: fs,
                                    wwfd: args.wwfd,
                                    newFileNameWithoutExtension: args.newFileNameWithoutExtension,
                                    broadcaster: broadcaster,
                                })];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_renameWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.services.workspaceService.rename(args.workspaceId, args.newName)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_updateFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.wwfd.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _this = this;
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.workspaceService.updateFile(fs, args.wwfd, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                    return [2, args.newContent];
                                }); }); }, broadcaster)];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_addRemote = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.addRemote(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_deleteRemote = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.deleteRemote(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_branch = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _this = this;
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.gitService.branch(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                                case 1:
                                    _c.sent();
                                    if (args.checkout) {
                                        broadcaster.broadcast({
                                            channel: args.workspaceId,
                                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    return [2, ({
                                                            type: "WS_CHECKOUT",
                                                            workspaceId: args.workspaceId,
                                                        })];
                                                });
                                            }); },
                                        });
                                    }
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_checkout = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _this = this;
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.gitService.checkout(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                                case 1:
                                    _c.sent();
                                    broadcaster.broadcast({
                                        channel: args.workspaceId,
                                        message: function () { return __awaiter(_this, void 0, void 0, function () {
                                            return __generator(this, function (_a) {
                                                return [2, ({
                                                        type: "WS_CHECKOUT",
                                                        workspaceId: args.workspaceId,
                                                    })];
                                            });
                                        }); },
                                    });
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_checkoutFilesFromLocalHead = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var workspaceDir;
                        var _this = this;
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0:
                                    workspaceDir = this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId });
                                    return [4, this.args.services.gitService.checkoutFilesFromLocalHead({
                                            fs: fs,
                                            dir: workspaceDir,
                                            ref: args.ref,
                                            filepaths: args.filepaths,
                                        })];
                                case 1:
                                    _c.sent();
                                    broadcaster.broadcast({
                                        channel: args.workspaceId,
                                        message: function () { return __awaiter(_this, void 0, void 0, function () {
                                            return __generator(this, function (_a) {
                                                return [2, ({
                                                        type: "WS_CHECKOUT_FILES_FROM_LOCAL_HEAD",
                                                        workspaceId: args.workspaceId,
                                                        relativePaths: args.filepaths,
                                                    })];
                                            });
                                        }); },
                                    });
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_getGitServerRefs = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.args.services.gitService.listServerRefs(args)];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_clone = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                console.log(args);
                return [2, this.createWorkspace({
                        preferredName: new URL(args.origin.url).pathname.substring(1),
                        origin: args.origin,
                        gitAuthSessionId: args.gitAuthSessionId,
                        gitInsecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                        storeFiles: function (fs, schema, workspace) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, this.args.services.gitService.clone({
                                            fs: fs,
                                            dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: workspace.workspaceId }),
                                            repositoryUrl: new URL(args.origin.url),
                                            gitConfig: args.gitConfig,
                                            authInfo: args.authInfo,
                                            sourceBranch: args.origin.branch,
                                            insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                                        })];
                                    case 1:
                                        _a.sent();
                                        return [2, this.args.services.workspaceService.getFilteredWorkspaceFileDescriptors(schema, workspace.workspaceId)];
                                }
                            });
                        }); },
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_getUnstagedModifiedFilesStatus = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceRootDirPath;
            var _this = this;
            return __generator(this, function (_a) {
                workspaceRootDirPath = this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId });
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _this = this;
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.gitService.unstagedModifiedFilesStatus({
                                        fs: fs,
                                        dir: workspaceRootDirPath,
                                        exclude: function (filepath) { return !_this.args.fileFilter.isEditable(filepath); },
                                    })];
                                case 1: return [2, _c.sent()];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_stageFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceRootDirPath;
            var _this = this;
            return __generator(this, function (_a) {
                workspaceRootDirPath = this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId });
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0: return [4, this.args.services.gitService.add({
                                        fs: fs,
                                        dir: workspaceRootDirPath,
                                        relativePath: args.relativePath,
                                    })];
                                case 1:
                                    _c.sent();
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_commit = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceRootDirPath;
            var _this = this;
            return __generator(this, function (_a) {
                workspaceRootDirPath = this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId });
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _c, _d, _e, _f;
                        var fs = _b.fs;
                        return __generator(this, function (_g) {
                            switch (_g.label) {
                                case 0: return [4, this.args.services.gitService.commit({
                                        fs: fs,
                                        dir: workspaceRootDirPath,
                                        targetBranch: args.targetBranch,
                                        message: args.commitMessage,
                                        author: {
                                            name: (_d = (_c = args.gitConfig) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : this.GIT_DEFAULT_USER.name,
                                            email: (_f = (_e = args.gitConfig) === null || _e === void 0 ? void 0 : _e.email) !== null && _f !== void 0 ? _f : this.GIT_DEFAULT_USER.email,
                                        },
                                    })];
                                case 1:
                                    _g.sent();
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_createSavePoint = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var descriptor, workspaceRootDirPath, defaultCommitMessage, unstagedModifiedFilesStatus;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                            var fs = _a.fs;
                            return _this.args.services.descriptorService.get(fs, args.workspaceId);
                        })];
                    case 1:
                        descriptor = _a.sent();
                        workspaceRootDirPath = this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId });
                        defaultCommitMessage = "Changes from ".concat(this.args.appName);
                        return [4, this.kieSandboxWorkspacesGit_getUnstagedModifiedFilesStatus({
                                workspaceId: args.workspaceId,
                            })];
                    case 2:
                        unstagedModifiedFilesStatus = _a.sent();
                        return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var _this = this;
                                var _c, _d, _e, _f, _g;
                                var fs = _b.fs, broadcaster = _b.broadcaster;
                                return __generator(this, function (_h) {
                                    switch (_h.label) {
                                        case 0: return [4, Promise.all(unstagedModifiedFilesStatus.map(function (stageStatusEntry) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0:
                                                            if (!(stageStatusEntry.status !== GitService_1.FileModificationStatus.deleted)) return [3, 2];
                                                            return [4, this.args.services.gitService.add({
                                                                    fs: fs,
                                                                    dir: workspaceRootDirPath,
                                                                    relativePath: stageStatusEntry.path,
                                                                })];
                                                        case 1:
                                                            _a.sent();
                                                            return [3, 4];
                                                        case 2: return [4, this.args.services.gitService.rm({
                                                                fs: fs,
                                                                dir: workspaceRootDirPath,
                                                                relativePath: stageStatusEntry.path,
                                                            })];
                                                        case 3:
                                                            _a.sent();
                                                            _a.label = 4;
                                                        case 4: return [2];
                                                    }
                                                });
                                            }); }))];
                                        case 1:
                                            _h.sent();
                                            return [4, this.args.services.gitService.commit({
                                                    fs: fs,
                                                    dir: workspaceRootDirPath,
                                                    targetBranch: descriptor.origin.branch,
                                                    message: (_c = args.commitMessage) !== null && _c !== void 0 ? _c : defaultCommitMessage,
                                                    author: {
                                                        name: (_e = (_d = args.gitConfig) === null || _d === void 0 ? void 0 : _d.name) !== null && _e !== void 0 ? _e : this.GIT_DEFAULT_USER.name,
                                                        email: (_g = (_f = args.gitConfig) === null || _f === void 0 ? void 0 : _f.email) !== null && _g !== void 0 ? _g : this.GIT_DEFAULT_USER.email,
                                                    },
                                                })];
                                        case 2:
                                            _h.sent();
                                            broadcaster.broadcast({
                                                channel: args.workspaceId,
                                                message: function () { return __awaiter(_this, void 0, void 0, function () {
                                                    return __generator(this, function (_a) {
                                                        return [2, ({
                                                                type: "WS_CREATE_SAVE_POINT",
                                                                workspaceId: args.workspaceId,
                                                            })];
                                                    });
                                                }); },
                                            });
                                            return [2];
                                    }
                                });
                            }); })];
                }
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_fetch = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.fetch(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_init = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.createWorkspace({
                        preferredName: args.preferredName,
                        origin: { kind: WorkspaceOrigin_1.WorkspaceKind.LOCAL, branch: GitConstants_1.GIT_DEFAULT_BRANCH },
                        gitAuthSessionId: args.gitAuthSessionId,
                        gitInsecurelyDisableTlsCertificateValidation: args.gitInsecurelyDisableTlsCertificateValidation,
                        storeFiles: function (fs, schema, workspace) { return __awaiter(_this, void 0, void 0, function () {
                            var files, workspaceRootDirAbsolutePath, ignoredPaths;
                            var _this = this;
                            var _a, _b, _c, _d;
                            return __generator(this, function (_e) {
                                switch (_e.label) {
                                    case 0:
                                        files = args.localFiles
                                            .filter(function (file) { return !file.path.startsWith(".git/"); })
                                            .map(function (localFile) {
                                            return new StorageService_1.StorageFile({
                                                path: _this.args.services.workspaceService.getAbsolutePath({
                                                    workspaceId: workspace.workspaceId,
                                                    relativePath: localFile.path,
                                                }),
                                                getFileContents: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                    return [2, localFile.fileContents];
                                                }); }); },
                                            });
                                        });
                                        return [4, Promise.all(files.map(function (f) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4, this.args.services.storageService.createOrOverwriteFile(fs, f)];
                                                        case 1:
                                                            _a.sent();
                                                            return [2];
                                                    }
                                                });
                                            }); }))];
                                    case 1:
                                        _e.sent();
                                        workspaceRootDirAbsolutePath = this.args.services.workspaceService.getAbsolutePath({
                                            workspaceId: workspace.workspaceId,
                                        });
                                        return [4, this.args.services.storageService.walk({
                                                schema: schema,
                                                shouldExcludeAbsolutePath: function () { return false; },
                                                baseAbsolutePath: workspaceRootDirAbsolutePath,
                                                onVisit: function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                                    var isIgnored;
                                                    var absolutePath = _b.absolutePath, relativePath = _b.relativePath;
                                                    return __generator(this, function (_c) {
                                                        switch (_c.label) {
                                                            case 0: return [4, this.args.services.gitService.isIgnored({
                                                                    fs: fs,
                                                                    dir: workspaceRootDirAbsolutePath,
                                                                    filepath: relativePath,
                                                                })];
                                                            case 1:
                                                                isIgnored = _c.sent();
                                                                return [2, isIgnored ? absolutePath : undefined];
                                                        }
                                                    });
                                                }); },
                                            })];
                                    case 2:
                                        ignoredPaths = _e.sent();
                                        return [4, Promise.all(ignoredPaths.map(function (path) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4, this.args.services.storageService.deleteFile(fs, path)];
                                                        case 1:
                                                            _a.sent();
                                                            return [2];
                                                    }
                                                });
                                            }); }))];
                                    case 3:
                                        _e.sent();
                                        return [4, this.args.services.gitService.init({
                                                fs: fs,
                                                dir: workspaceRootDirAbsolutePath,
                                            })];
                                    case 4:
                                        _e.sent();
                                        return [4, this.args.services.gitService.add({
                                                fs: fs,
                                                dir: workspaceRootDirAbsolutePath,
                                                relativePath: ".",
                                            })];
                                    case 5:
                                        _e.sent();
                                        return [4, this.args.services.gitService.commit({
                                                fs: fs,
                                                dir: workspaceRootDirAbsolutePath,
                                                message: "Initial commit from ".concat(this.args.appName),
                                                targetBranch: GitConstants_1.GIT_DEFAULT_BRANCH,
                                                author: {
                                                    name: (_b = (_a = args.gitConfig) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : this.GIT_DEFAULT_USER.name,
                                                    email: (_d = (_c = args.gitConfig) === null || _c === void 0 ? void 0 : _c.email) !== null && _d !== void 0 ? _d : this.GIT_DEFAULT_USER.email,
                                                },
                                            })];
                                    case 6:
                                        _e.sent();
                                        return [2, this.args.services.workspaceService.getFilteredWorkspaceFileDescriptors(schema, workspace.workspaceId)];
                                }
                            });
                        }); },
                    })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_pull = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspace;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.services.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                            var fs = _a.fs;
                            return _this.args.services.descriptorService.get(fs, args.workspaceId);
                        })];
                    case 1:
                        workspace = _a.sent();
                        return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var _this = this;
                                var _c, _d, _e, _f;
                                var fs = _b.fs, broadcaster = _b.broadcaster;
                                return __generator(this, function (_g) {
                                    switch (_g.label) {
                                        case 0: return [4, this.args.services.gitService.pull({
                                                fs: fs,
                                                dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }),
                                                ref: workspace.origin.branch,
                                                author: {
                                                    name: (_d = (_c = args.gitConfig) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : this.GIT_DEFAULT_USER.name,
                                                    email: (_f = (_e = args.gitConfig) === null || _e === void 0 ? void 0 : _e.email) !== null && _f !== void 0 ? _f : this.GIT_DEFAULT_USER.email,
                                                },
                                                authInfo: args.authInfo,
                                                insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                                            })];
                                        case 1:
                                            _g.sent();
                                            broadcaster.broadcast({
                                                channel: args.workspaceId,
                                                message: function () { return __awaiter(_this, void 0, void 0, function () {
                                                    return __generator(this, function (_a) {
                                                        return [2, ({
                                                                type: "WS_PULL",
                                                                workspaceId: args.workspaceId,
                                                            })];
                                                    });
                                                }); },
                                            });
                                            return [2];
                                    }
                                });
                            }); })];
                }
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_push = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs, broadcaster = _b.broadcaster;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.push(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_deleteBranch = function (args) {
        var _this = this;
        return this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
            var fs = _b.fs, broadcaster = _b.broadcaster;
            return __generator(this, function (_c) {
                return [2, this.args.services.gitService.deleteBranch(__assign({ fs: fs, dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }) }, args))];
            });
        }); });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_resolveRef = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadonlyInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.resolveRef({
                                    fs: fs,
                                    dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }),
                                    ref: args.ref,
                                })];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_isModified = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.isModified({
                                    fs: fs,
                                    dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }),
                                    relativePath: args.relativePath,
                                })];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesGit_hasLocalChanges = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, this.args.services.workspaceFsService.withReadWriteInMemoryFs(args.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                        var _this = this;
                        var fs = _b.fs;
                        return __generator(this, function (_c) {
                            return [2, this.args.services.gitService.hasLocalChanges({
                                    fs: fs,
                                    dir: this.args.services.workspaceService.getAbsolutePath({ workspaceId: args.workspaceId }),
                                    exclude: function (filepath) { return !_this.args.fileFilter.isEditable(filepath); },
                                })];
                        });
                    }); })];
            });
        });
    };
    WorkspacesWorkerApiImpl.prototype.kieSandboxWorkspacesStorage_flushes = function () {
        return { defaultValue: [] };
    };
    WorkspacesWorkerApiImpl.prototype.createWorkspace = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, workspace, files, filteredFiles, suggestedFirstFile;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, this.args.services.workspaceService.create({
                            storeFiles: args.storeFiles,
                            origin: args.origin,
                            preferredName: args.preferredName,
                            gitAuthSessionId: args.gitAuthSessionId,
                            gitInsecurelyDisableTlsCertificateValidation: args.gitInsecurelyDisableTlsCertificateValidation,
                        })];
                    case 1:
                        _a = _b.sent(), workspace = _a.workspace, files = _a.files;
                        if (files.length <= 0) {
                            return [2, { workspace: workspace, suggestedFirstFile: undefined }];
                        }
                        filteredFiles = files.filter(function (file) { return _this.args.fileFilter.isModel(file.relativePath); });
                        if (!filteredFiles.length) {
                            filteredFiles = files.filter(function (file) { return _this.args.fileFilter.isEditable(file.relativePath); });
                        }
                        if (!filteredFiles.length) {
                            filteredFiles = files.filter(function (file) { return _this.args.fileFilter.isSupported(file.relativePath); });
                        }
                        filteredFiles.sort(function (a, b) { return a.relativePath.localeCompare(b.relativePath); });
                        suggestedFirstFile = filteredFiles.length ? filteredFiles[0] : undefined;
                        return [2, {
                                workspace: workspace,
                                suggestedFirstFile: suggestedFirstFile,
                            }];
                }
            });
        });
    };
    return WorkspacesWorkerApiImpl;
}());
exports.WorkspacesWorkerApiImpl = WorkspacesWorkerApiImpl;
//# sourceMappingURL=WorkspacesWorkerApiImpl.js.map