import * as React from "react";
export class ErrorBoundary extends React.Component {
    constructor(props) {
        super(props);
        this.state = { hasError: false };
    }
    reset() {
        this.props.setHasError(false);
        this.setState({ hasError: false });
    }
    componentDidCatch(error, errorInfo) {
        this.props.setHasError(true);
        console.error("Error", error, errorInfo);
    }
    render() {
        if (this.state.hasError) {
            return this.props.error;
        }
        return this.props.children;
    }
    static getDerivedStateFromError(error) {
        return { hasError: true };
    }
}
//# sourceMappingURL=ErrorBoundary.js.map