"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeKieEditorControllerFactory = void 0;
var vscode_1 = require("vscode");
var __path = require("path");
var api_1 = require("@kie-tools-core/editor/dist/api");
var VsCodeKieEditorController_1 = require("./VsCodeKieEditorController");
var VsCodeResourceContentServiceForDanglingFiles_1 = require("./workspace/VsCodeResourceContentServiceForDanglingFiles");
var VsCodeResourceContentServiceForWorkspaces_1 = require("./workspace/VsCodeResourceContentServiceForWorkspaces");
var VsCodeKieEditorChannelApiProducer_1 = require("./VsCodeKieEditorChannelApiProducer");
var workspaceRoot_1 = require("./workspace/workspaceRoot");
var VsCodeKieEditorControllerFactory = (function () {
    function VsCodeKieEditorControllerFactory(context, editorStore, editorEnvelopeLocator, messageBroadcaster, vscodeWorkspace, vscodeNotifications, javaCodeCompletionApi, viewType, i18n, channelApiProducer) {
        if (channelApiProducer === void 0) { channelApiProducer = new VsCodeKieEditorChannelApiProducer_1.DefaultVsCodeEditorChannelApiProducer(); }
        this.context = context;
        this.editorStore = editorStore;
        this.editorEnvelopeLocator = editorEnvelopeLocator;
        this.messageBroadcaster = messageBroadcaster;
        this.vscodeWorkspace = vscodeWorkspace;
        this.vscodeNotifications = vscodeNotifications;
        this.javaCodeCompletionApi = javaCodeCompletionApi;
        this.viewType = viewType;
        this.i18n = i18n;
        this.channelApiProducer = channelApiProducer;
    }
    VsCodeKieEditorControllerFactory.prototype.configureNew = function (webviewPanel, document) {
        webviewPanel.webview.options = {
            enableCommandUris: true,
            enableScripts: true,
            localResourceRoots: [this.context.extensionUri],
        };
        var editorEnvelopeLocator = this.getEditorEnvelopeLocatorForWebview(webviewPanel.webview);
        var resourceContentService = this.createResourceContentService(document);
        var envelopeMapping = editorEnvelopeLocator.getEnvelopeMapping(document.document.uri.fsPath);
        if (!envelopeMapping) {
            throw new Error("No envelope mapping found for '".concat(document.document.uri, "'"));
        }
        var editor = new VsCodeKieEditorController_1.VsCodeKieEditorController(document, webviewPanel, this.context, this.editorStore, envelopeMapping, editorEnvelopeLocator, this.messageBroadcaster);
        var editorChannelApi = this.getChannelApi(editor, resourceContentService);
        this.editorStore.addAsActive(editor);
        editor.startListening(editorChannelApi);
        editor.startInitPolling(editorChannelApi);
        editor.setupPanelActiveStatusChange();
        editor.setupPanelOnDidDispose();
        editor.setupWebviewContent();
        editor.startListeningToThemeChanges();
        editor.startListeningToDocumentChanges();
    };
    VsCodeKieEditorControllerFactory.prototype.createResourceContentService = function (document) {
        var workspaceRoot = (0, workspaceRoot_1.getWorkspaceRoot)(document.document);
        if (workspaceRoot.type === "workspace") {
            return new VsCodeResourceContentServiceForWorkspaces_1.VsCodeResourceContentServiceForWorkspaces({
                workspaceRootAbsoluteFsPath: workspaceRoot.workspaceRootAbsoluteFsPath,
                document: document.document,
            });
        }
        else if (workspaceRoot.type === "dangling") {
            return new VsCodeResourceContentServiceForDanglingFiles_1.VsCodeResourceContentServiceForDanglingFiles({ openFileAbsoluteFsPath: document.document.uri.fsPath });
        }
        else {
            throw new Error("Unknown workspaceRoot type: " + workspaceRoot.type);
        }
    };
    VsCodeKieEditorControllerFactory.prototype.getChannelApi = function (editor, resourceContentService) {
        return this.channelApiProducer.get(editor, resourceContentService, this.vscodeWorkspace, this.vscodeNotifications, this.javaCodeCompletionApi, this.viewType, this.i18n);
    };
    VsCodeKieEditorControllerFactory.prototype.getEditorEnvelopeLocatorForWebview = function (webview) {
        var _this = this;
        return new api_1.EditorEnvelopeLocator(this.editorEnvelopeLocator.targetOrigin, __spreadArray([], __read(this.editorEnvelopeLocator.envelopeMappings), false).reduce(function (envelopeMappings, mapping) {
            envelopeMappings.push(new api_1.EnvelopeMapping({
                type: mapping.type,
                filePathGlob: mapping.filePathGlob,
                resourcesPathPrefix: _this.getWebviewPath(webview, mapping.resourcesPathPrefix),
                envelopeContent: {
                    type: api_1.EnvelopeContentType.PATH,
                    path: _this.getWebViewPathFromEnvelopeContent(webview, mapping.envelopeContent),
                },
            }));
            return envelopeMappings;
        }, []));
    };
    VsCodeKieEditorControllerFactory.prototype.getWebViewPathFromEnvelopeContent = function (webview, envelopeContent) {
        if (envelopeContent.type === api_1.EnvelopeContentType.PATH) {
            return this.getWebviewPath(webview, envelopeContent.path);
        }
        return "";
    };
    VsCodeKieEditorControllerFactory.prototype.getWebviewPath = function (webview, relativeUriPath) {
        return webview.asWebviewUri(vscode_1.Uri.joinPath(this.context.extensionUri, relativeUriPath)).toString();
    };
    VsCodeKieEditorControllerFactory.prototype.getParentFolder = function (absoluteFsPath) {
        if (absoluteFsPath.includes(__path.sep)) {
            return absoluteFsPath.substring(0, absoluteFsPath.lastIndexOf(__path.sep) + 1);
        }
        return "";
    };
    return VsCodeKieEditorControllerFactory;
}());
exports.VsCodeKieEditorControllerFactory = VsCodeKieEditorControllerFactory;
//# sourceMappingURL=VsCodeKieEditorControllerFactory.js.map