"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProblemsTabNotificationHandler = void 0;
var vscode = require("vscode");
var workspaceRoot_1 = require("../workspace/workspaceRoot");
var paths_1 = require("../paths/paths");
var __path = require("path");
var DIAGNOSTIC_COLLECTION_NAME = "kie-tools-vscode-extensions";
var KOGITO_NOTIFICATION_TO_VS_CODE_DIAGNOSTIC_SEVERITY_CONVERSION_MAP = {
    INFO: vscode.DiagnosticSeverity.Information,
    WARNING: vscode.DiagnosticSeverity.Warning,
    ERROR: vscode.DiagnosticSeverity.Error,
    HINT: vscode.DiagnosticSeverity.Hint,
    SUCCESS: vscode.DiagnosticSeverity.Information,
};
var ProblemsTabNotificationHandler = (function () {
    function ProblemsTabNotificationHandler() {
        this.diagnosticCollection = vscode.languages.createDiagnosticCollection(DIAGNOSTIC_COLLECTION_NAME);
    }
    ProblemsTabNotificationHandler.prototype.createNotification = function (document, notification) {
        var _a;
        var workspaceRoot = (0, workspaceRoot_1.getWorkspaceRoot)(document);
        var uri = vscode.Uri.file(__path.join(workspaceRoot.workspaceRootAbsoluteFsPath, (0, paths_1.toFsPath)(notification.normalizedPosixPathRelativeToTheWorkspaceRoot)));
        var diagnostics = ((_a = this.diagnosticCollection.get(uri)) === null || _a === void 0 ? void 0 : _a.map(function (elem) { return elem; })) || [];
        diagnostics.push(this.buildDiagnostic(notification));
        this.diagnosticCollection.set(uri, diagnostics);
    };
    ProblemsTabNotificationHandler.prototype.setProblemsEntries = function (document, normalizedPosixPathRelativeToTheWorkspaceRoot, notifications) {
        var _this = this;
        var workspaceRoot = (0, workspaceRoot_1.getWorkspaceRoot)(document);
        var uri = vscode.Uri.file(__path.join(workspaceRoot.workspaceRootAbsoluteFsPath, (0, paths_1.toFsPath)(normalizedPosixPathRelativeToTheWorkspaceRoot)));
        var diagnostics = notifications.map(function (notification) { return _this.buildDiagnostic(notification); });
        this.diagnosticCollection.set(uri, diagnostics);
    };
    ProblemsTabNotificationHandler.prototype.removeNotifications = function (document, normalizedPosixPathRelativeToTheWorkspaceRoot) {
        var workspaceRoot = (0, workspaceRoot_1.getWorkspaceRoot)(document);
        var uri = vscode.Uri.file(__path.join(workspaceRoot.workspaceRootAbsoluteFsPath, (0, paths_1.toFsPath)(normalizedPosixPathRelativeToTheWorkspaceRoot)));
        this.diagnosticCollection.delete(uri);
    };
    ProblemsTabNotificationHandler.prototype.buildDiagnostic = function (notification) {
        var _a, _b, _c, _d, _e, _f, _g;
        var startLineNumber = ((_a = notification.position) === null || _a === void 0 ? void 0 : _a.startLineNumber) ? ((_b = notification.position) === null || _b === void 0 ? void 0 : _b.startLineNumber) - 1 : 0;
        var startColumn = ((_c = notification.position) === null || _c === void 0 ? void 0 : _c.startColumn) ? ((_d = notification.position) === null || _d === void 0 ? void 0 : _d.startColumn) - 1 : 0;
        var endColumn = ((_e = notification.position) === null || _e === void 0 ? void 0 : _e.endColumn) || 0;
        var endLineNumber = ((_f = notification.position) === null || _f === void 0 ? void 0 : _f.endLineNumber) ? ((_g = notification.position) === null || _g === void 0 ? void 0 : _g.endLineNumber) - 1 : 0;
        return {
            message: notification.message,
            range: new vscode.Range(startLineNumber, startColumn, endLineNumber, endColumn),
            severity: this.getSeverity(notification.severity),
        };
    };
    ProblemsTabNotificationHandler.prototype.getSeverity = function (severity) {
        var diagnostic = KOGITO_NOTIFICATION_TO_VS_CODE_DIAGNOSTIC_SEVERITY_CONVERSION_MAP[severity];
        return diagnostic ? vscode.DiagnosticSeverity.Information : diagnostic;
    };
    return ProblemsTabNotificationHandler;
}());
exports.ProblemsTabNotificationHandler = ProblemsTabNotificationHandler;
//# sourceMappingURL=ProblemsTabNotificationHandler.js.map