"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessWorkflowDiagramEditorFactory = void 0;
var api_1 = require("@kie-tools-core/editor/dist/api");
var common_1 = require("@kie-tools/kie-bc-editors/dist/common");
var api_2 = require("../api");
var DiagramService_1 = require("../api/DiagramService");
var ServerlessWorkflowDiagramEditor_1 = require("./ServerlessWorkflowDiagramEditor");
var ServerlessWorkflowDiagramEditorFactory = (function () {
    function ServerlessWorkflowDiagramEditorFactory(gwtEditorEnvelopeConfig) {
        this.gwtEditorEnvelopeConfig = gwtEditorEnvelopeConfig;
    }
    ServerlessWorkflowDiagramEditorFactory.prototype.createEditor = function (ctx, initArgs) {
        var _a;
        window.envelope = __assign(__assign({}, ((_a = window.envelope) !== null && _a !== void 0 ? _a : {})), { diagramService: new DiagramService_1.DiagramService(ctx) });
        var languageData = (0, api_2.getServerlessWorkflowLanguageData)(initArgs.resourcesPathPrefix);
        var factory = new common_1.GwtEditorWrapperFactory(languageData, function (self) {
            return new ServerlessWorkflowDiagramEditor_1.ServerlessWorkflowDiagramEditorImpl(languageData.editorId, self.gwtAppFormerConsumedInteropApi.getEditor(languageData.editorId), ctx.channelApi, self.textFormatter, self.gwtStateControlService, self.kieBcEditorsI18n);
        }, this.gwtEditorEnvelopeConfig);
        ctx.supportedThemes = [api_1.EditorTheme.LIGHT, api_1.EditorTheme.DARK];
        return factory.createEditor(ctx, initArgs);
    };
    return ServerlessWorkflowDiagramEditorFactory;
}());
exports.ServerlessWorkflowDiagramEditorFactory = ServerlessWorkflowDiagramEditorFactory;
//# sourceMappingURL=ServerlessWorkflowDiagramEditorFactory.js.map