import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { ExternalLinkAltIcon } from "@patternfly/react-icons/dist/js/icons/external-link-alt-icon";
import { componentOuiaProps } from "../../ouiaTools";
import { Truncate } from "@patternfly/react-core/dist/js/components/Truncate";
export const EndpointLink = ({ serviceUrl, isLinkShown, linkLabel, ouiaId, ouiaSafe, }) => {
    if (serviceUrl) {
        return (_jsxs(Button, { component: "a", variant: "link", target: "_blank", href: `${serviceUrl}`, isInline: true, ...componentOuiaProps(ouiaId, "endpoint-link", ouiaSafe), children: [_jsx(Truncate, { content: isLinkShown ? serviceUrl : linkLabel || "Endpoint", style: { maxWidth: "90%", minWidth: "0" } }), _jsx(ExternalLinkAltIcon, { className: "pf-u-ml-xs" })] }));
    }
    else {
        return _jsx(_Fragment, {});
    }
};
//# sourceMappingURL=EndpointLink.js.map