import { jsxs as _jsxs, jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useState } from "react";
import { DataList, DataListItem, DataListCell } from "@patternfly/react-core/dist/js/components/DataList";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { DropdownItem, Dropdown, DropdownToggle, DropdownToggleAction, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { componentOuiaProps } from "../../ouiaTools";
import "../styles.css";
import { CheckIcon } from "@patternfly/react-icons/dist/js/icons/check-icon";
export const LoadMore = ({ offset, setOffset, getMoreItems, pageSize, isLoadingMore, setLoadMoreClicked, ouiaId, ouiaSafe, }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [loadMoreValue, setLoadMoreValue] = useState(10);
    const loadMore = (newPageSize) => {
        setLoadMoreClicked && setLoadMoreClicked(true);
        const newOffset = offset + pageSize;
        setOffset(newOffset);
        getMoreItems(newOffset, newPageSize);
    };
    const onToggle = (isDropdownOpen) => {
        setIsOpen(isDropdownOpen);
    };
    const onSelect = (event) => {
        const selectedValue = parseInt(event.currentTarget.id, 10);
        setLoadMoreValue(selectedValue);
    };
    const dropdownItem = (count) => {
        return (_jsx(DropdownItem, { component: "button", id: count.toString(), children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: ["Load ", count, " more"] }), loadMoreValue === count && (_jsx(SplitItem, { children: _jsx(CheckIcon, { size: "sm", color: "var(--pf-global--info-color--100)" }) }))] }) }, "loadmore" + count));
    };
    return (_jsx(DataList, { "aria-label": "Simple data list example", ...componentOuiaProps(ouiaId, "load-more", ouiaSafe ? ouiaSafe : !isLoadingMore), children: _jsx(DataListItem, { "aria-labelledby": "kie-datalist-item", children: _jsx(DataListCell, { className: "kogito-components-common__load-more", children: _jsx("div", { className: "pf-u-float-right pf-u-mr-md", children: _jsx(Dropdown, { onSelect: onSelect, direction: "up", toggle: _jsx(DropdownToggle, { id: `toggle-id`, onToggle: onToggle, splitButtonItems: [
                                _jsx(DropdownToggleAction, { onClick: () => {
                                        loadMore(loadMoreValue);
                                        setIsOpen(false);
                                    }, children: isLoadingMore ? (_jsxs(_Fragment, { children: ["Loading...", _jsx(Spinner, { size: "md", className: "kogito-components-common__load-more-spinner" }), " "] })) : (`Load ${loadMoreValue} more`) }, `toggle-id-${ouiaId}`),
                            ] }), isOpen: isOpen, dropdownItems: [dropdownItem(10), dropdownItem(20), dropdownItem(50), dropdownItem(100)] }) }) }) }) }));
};
//# sourceMappingURL=LoadMore.js.map