import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
export const setTitle = (titleStatus, titleText) => {
    let icon;
    switch (titleStatus) {
        case "success":
            icon = _jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--info-color--100)" });
            break;
        case "failure":
            icon = _jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" });
            break;
    }
    return (_jsxs(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: [icon, _jsx("span", { children: titleText })] }));
};
export const constructObject = (obj, path, val) => {
    const keys = path.split(",");
    const lastKey = keys.pop();
    const lastObj = keys.reduce((_obj, key) => (_obj[key] = obj[key] || {}), obj);
    lastObj[lastKey] = val;
};
//# sourceMappingURL=Utils.js.map