import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { DashbuilderEditor } from "./DashbuilderEditor";
export class DashbuilderEditorView {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
        this.editorRef = React.createRef();
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.editorRef.current.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    }
    getContent() {
        return this.editorRef.current.getContent();
    }
    getPreview() {
        return this.editorRef.current.getPreview();
    }
    af_componentRoot() {
        return (_jsx(DashbuilderEditor, { ref: this.editorRef, channelType: this.initArgs.channel, onReady: () => this.envelopeContext.channelApi.notifications.kogitoEditor_ready.send(), onNewEdit: (edit) => {
                this.envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send(edit);
            }, setNotifications: (path, notifications) => this.envelopeContext.channelApi.notifications.kogitoNotifications_setNotifications.send(path, notifications), onStateControlCommandUpdate: (command) => this.envelopeContext.channelApi.notifications.kogitoEditor_stateControlCommandUpdate.send(command) }));
    }
    async undo() {
        return this.editorRef.current.undo();
    }
    async redo() {
        return this.editorRef.current.redo();
    }
    async validate() {
        return this.editorRef.current.validate();
    }
    async setTheme(theme) {
        return this.editorRef.current.setTheme(theme);
    }
    moveCursorToPosition(position) {
        this.editorRef.current.moveCursorToPosition(position);
    }
}
//# sourceMappingURL=DashbuilderEditorView.js.map